/*
 * Decompiled with CFR 0.152.
 */
package com.blocklogic.agritech.block.entity;

import com.blocklogic.agritech.block.ModBlocks;
import com.blocklogic.agritech.block.entity.ModBlockEntities;
import com.blocklogic.agritech.config.AgritechCropConfig;
import com.blocklogic.agritech.screen.custom.AgritechPlanterMenu;
import com.blocklogic.agritech.util.RegistryHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgritechPlanterBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(8){

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return 1;
            }
            return super.getSlotLimit(slot);
        }

        protected void onContentsChanged(int slot) {
            AgritechPlanterBlockEntity.this.setChanged();
            if (!AgritechPlanterBlockEntity.this.level.isClientSide()) {
                AgritechPlanterBlockEntity.this.level.sendBlockUpdated(AgritechPlanterBlockEntity.this.getBlockPos(), AgritechPlanterBlockEntity.this.getBlockState(), AgritechPlanterBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    private final OutputOnlyItemHandler outputHandler = new OutputOnlyItemHandler(this, this.inventory, 2, 7);
    private int growthStage = 0;
    public int maxGrowthStage = 8;
    private int growthTicks = 0;
    private int ticksToNextStage = 100;
    private boolean readyToHarvest = false;

    public IItemHandler getOutputHandler() {
        return this.outputHandler;
    }

    public AgritechPlanterBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.AGRITECH_PLANTER_BLOCK_ENTITY.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"blockentity.agritech.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new AgritechPlanterMenu(i, inventory, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithFullMetadata(pRegistries);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AgritechPlanterBlockEntity blockEntity) {
        if (level.isClientSide()) {
            return;
        }
        ItemStack seedStack = blockEntity.inventory.getStackInSlot(0);
        ItemStack soilStack = blockEntity.inventory.getStackInSlot(1);
        if (seedStack.isEmpty() || soilStack.isEmpty()) {
            blockEntity.resetGrowth();
            return;
        }
        float growthModifier = blockEntity.getGrowthModifier(soilStack);
        if (!blockEntity.readyToHarvest) {
            ++blockEntity.growthTicks;
            if ((float)blockEntity.growthTicks >= (float)blockEntity.ticksToNextStage / growthModifier) {
                blockEntity.growthTicks = 0;
                ++blockEntity.growthStage;
                if (blockEntity.growthStage >= blockEntity.maxGrowthStage) {
                    blockEntity.readyToHarvest = true;
                }
                level.sendBlockUpdated(pos, state, state, 3);
                blockEntity.setChanged();
            }
        }
        if (blockEntity.readyToHarvest && blockEntity.hasOutputSpace()) {
            blockEntity.harvestCrop();
        }
        if (state.is((Block)ModBlocks.AGRITECH_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.ACACIA_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.BAMBOO_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.BIRCH_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.CHERRY_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.CRIMSON_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.DARK_OAK_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.JUNGLE_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.MANGROVE_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.SPRUCE_HOPPING_PLANTER_BLOCK.get()) || state.is((Block)ModBlocks.WARPED_HOPPING_PLANTER_BLOCK.get())) {
            AgritechPlanterBlockEntity.tryOutputItemsBelow(level, pos, blockEntity);
        }
    }

    public float getGrowthModifier(ItemStack soilStack) {
        if (soilStack.isEmpty()) {
            return 1.0f;
        }
        String soilId = RegistryHelper.getItemId(soilStack);
        return AgritechCropConfig.getSoilGrowthModifier(soilId);
    }

    private static void tryOutputItemsBelow(Level level, BlockPos pos, AgritechPlanterBlockEntity blockEntity) {
        BlockPos belowPos = pos.below();
        BlockEntity targetEntity = level.getBlockEntity(belowPos);
        if (targetEntity == null) {
            return;
        }
        IItemHandler targetInventory = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, belowPos, (Object)Direction.UP);
        if (targetInventory == null) {
            return;
        }
        boolean changed = false;
        for (int slot = 2; slot < 8; ++slot) {
            ItemStack extractedItem;
            if (blockEntity.inventory.getStackInSlot(slot).isEmpty() || (extractedItem = blockEntity.inventory.extractItem(slot, 64, true)).isEmpty()) continue;
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInventory, (ItemStack)extractedItem, (boolean)false);
            int insertedAmount = extractedItem.getCount() - remaining.getCount();
            if (insertedAmount <= 0) continue;
            blockEntity.inventory.extractItem(slot, insertedAmount, false);
            changed = true;
        }
        if (changed) {
            blockEntity.setChanged();
            level.sendBlockUpdated(pos, level.getBlockState(pos), level.getBlockState(pos), 3);
        }
    }

    public boolean hasOutputSpace() {
        List<ItemStack> potentialDrops = this.getHarvestDrops(this.inventory.getStackInSlot(0));
        HashMap<Integer, ItemStack> simulatedSlots = new HashMap<Integer, ItemStack>();
        for (int slot = 2; slot < 8; ++slot) {
            ItemStack stack = this.inventory.getStackInSlot(slot);
            simulatedSlots.put(slot, stack.isEmpty() ? ItemStack.EMPTY : stack.copy());
        }
        for (ItemStack drop : potentialDrops) {
            ItemStack existingStack;
            int slot;
            int remainingToPlace = drop.getCount();
            for (slot = 2; slot < 8; ++slot) {
                existingStack = (ItemStack)simulatedSlots.get(slot);
                if (existingStack.isEmpty() || !existingStack.is(drop.getItem()) || existingStack.getCount() >= existingStack.getMaxStackSize()) continue;
                int spaceAvailable = existingStack.getMaxStackSize() - existingStack.getCount();
                int itemsToAdd = Math.min(spaceAvailable, remainingToPlace);
                existingStack.grow(itemsToAdd);
                if ((remainingToPlace -= itemsToAdd) <= 0) break;
            }
            if (remainingToPlace > 0) {
                for (slot = 2; slot < 8; ++slot) {
                    existingStack = (ItemStack)simulatedSlots.get(slot);
                    if (!existingStack.isEmpty()) continue;
                    simulatedSlots.put(slot, new ItemStack((ItemLike)drop.getItem(), remainingToPlace));
                    remainingToPlace = 0;
                    break;
                }
            }
            if (remainingToPlace <= 0) continue;
            return false;
        }
        return true;
    }

    public void resetGrowth() {
        this.growthStage = 0;
        this.growthTicks = 0;
        this.readyToHarvest = false;
        this.setChanged();
    }

    public void harvestCrop() {
        if (!this.readyToHarvest) {
            return;
        }
        ItemStack seedStack = this.inventory.getStackInSlot(0);
        List<ItemStack> drops = this.getHarvestDrops(seedStack);
        for (ItemStack dropStack : drops) {
            int remainingItemsToPlace = dropStack.getCount();
            while (remainingItemsToPlace > 0) {
                ItemStack existingStack;
                int slot;
                boolean itemPlaced = false;
                for (slot = 2; slot < 8; ++slot) {
                    existingStack = this.inventory.getStackInSlot(slot);
                    if (existingStack.isEmpty() || !existingStack.is(dropStack.getItem()) || existingStack.getCount() >= existingStack.getMaxStackSize()) continue;
                    int spaceAvailable = existingStack.getMaxStackSize() - existingStack.getCount();
                    int itemsToAdd = Math.min(spaceAvailable, remainingItemsToPlace);
                    existingStack.grow(itemsToAdd);
                    this.inventory.setStackInSlot(slot, existingStack);
                    itemPlaced = true;
                    if ((remainingItemsToPlace -= itemsToAdd) <= 0) break;
                }
                if (remainingItemsToPlace > 0) {
                    for (slot = 2; slot < 8; ++slot) {
                        existingStack = this.inventory.getStackInSlot(slot);
                        if (!existingStack.isEmpty()) continue;
                        ItemStack newStack = new ItemStack((ItemLike)dropStack.getItem(), remainingItemsToPlace);
                        this.inventory.setStackInSlot(slot, newStack);
                        remainingItemsToPlace = 0;
                        itemPlaced = true;
                        break;
                    }
                }
                if (itemPlaced) continue;
                break;
            }
            if (remainingItemsToPlace <= 0) continue;
            break;
        }
        this.resetGrowth();
    }

    private List<ItemStack> getHarvestDrops(ItemStack seedStack) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        Random random = new Random();
        if (seedStack.isEmpty()) {
            return drops;
        }
        String seedId = RegistryHelper.getItemId(seedStack);
        List<AgritechCropConfig.DropInfo> configDrops = AgritechCropConfig.getCropDrops(seedId);
        for (AgritechCropConfig.DropInfo dropInfo : configDrops) {
            Item item;
            if (!(random.nextFloat() <= dropInfo.chance)) continue;
            int count = dropInfo.minCount;
            if (dropInfo.maxCount > dropInfo.minCount) {
                count = dropInfo.minCount + random.nextInt(dropInfo.maxCount - dropInfo.minCount + 1);
            }
            if ((item = RegistryHelper.getItem(dropInfo.item)) == null) continue;
            drops.add(new ItemStack((ItemLike)item, count));
        }
        return drops;
    }

    public float getGrowthProgress() {
        if (this.maxGrowthStage <= 0 || this.readyToHarvest) {
            return 0.0f;
        }
        float stageProgress = (float)this.growthTicks / ((float)this.ticksToNextStage / this.getGrowthModifier(this.inventory.getStackInSlot(1)));
        float overallProgress = ((float)this.growthStage + stageProgress) / (float)this.maxGrowthStage;
        return Math.min(overallProgress, 1.0f);
    }

    public int getProgressBarWidth(int maxWidth) {
        return (int)(this.getGrowthProgress() * (float)maxWidth);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
        tag.putInt("growthStage", this.growthStage);
        tag.putInt("growthTicks", this.growthTicks);
        tag.putBoolean("readyToHarvest", this.readyToHarvest);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        this.growthStage = tag.getInt("growthStage");
        this.growthTicks = tag.getInt("growthTicks");
        this.readyToHarvest = tag.getBoolean("readyToHarvest");
    }

    public int getGrowthStage() {
        return this.growthStage;
    }

    private class OutputOnlyItemHandler
    implements IItemHandler {
        private final ItemStackHandler original;
        private final int firstOutputSlot;
        private final int lastOutputSlot;

        public OutputOnlyItemHandler(AgritechPlanterBlockEntity agritechPlanterBlockEntity, ItemStackHandler original, int firstOutputSlot, int lastOutputSlot) {
            this.original = original;
            this.firstOutputSlot = firstOutputSlot;
            this.lastOutputSlot = lastOutputSlot;
        }

        public int getSlots() {
            return this.original.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.original.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= this.firstOutputSlot && slot <= this.lastOutputSlot) {
                return this.original.extractItem(slot, amount, simulate);
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            return this.original.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    }
}

