/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting.alkahestry;

import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import reliquary.Reliquary;
import reliquary.crafting.AlkahestryCraftingRecipe;
import reliquary.crafting.conditions.AlkahestryEnabledCondition;

public class CraftingRecipeBuilder {
    private final Ingredient ingredient;
    private final int charge;
    private final int resultCount;

    private CraftingRecipeBuilder(Ingredient ingredient, int charge, int resultCount) {
        this.ingredient = ingredient;
        this.charge = charge;
        this.resultCount = resultCount;
    }

    public static CraftingRecipeBuilder craftingRecipe(ItemLike item, int charge, int resultCount) {
        return new CraftingRecipeBuilder(Ingredient.of((ItemLike[])new ItemLike[]{item}), charge, resultCount);
    }

    public static CraftingRecipeBuilder craftingRecipe(TagKey<Item> tag, int charge, int resultCount) {
        return new CraftingRecipeBuilder(Ingredient.of(tag), charge, resultCount);
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        ResourceLocation fullId = Reliquary.getRL("alkahestry/crafting/" + id.getPath());
        recipeOutput.withConditions(new ICondition[]{new AlkahestryEnabledCondition()}).accept(fullId, (Recipe)new AlkahestryCraftingRecipe(this.ingredient, this.charge, this.resultCount), null);
    }
}

