/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.setup.networking;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.common.block.WarpNexus;
import com.github.jarva.arsadditions.common.block.tile.WarpNexusTile;
import com.github.jarva.arsadditions.server.util.TeleportUtil;
import com.github.jarva.arsadditions.setup.networking.NetworkHandler;
import com.github.jarva.arsadditions.setup.registry.AddonAttachmentRegistry;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TeleportNexusPacket(BlockPos pos, int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportNexusPacket> TYPE = new CustomPacketPayload.Type(ArsAdditions.prefix("teleport_nexus"));
    public static final StreamCodec<ByteBuf, TeleportNexusPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TeleportNexusPacket::pos, (StreamCodec)ByteBufCodecs.VAR_INT, TeleportNexusPacket::index, TeleportNexusPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handleData(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WarpNexusTile be = WarpNexusTile.getWarpNexus(player.level(), this.pos).orElse(null);
            if (be == null) {
                return;
            }
            if (player.blockPosition().distToCenterSqr((double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ()) > Math.pow(player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 2.0)) {
                return;
            }
            ItemStackHandler nexus = (ItemStackHandler)player.getData(AddonAttachmentRegistry.WARP_NEXUS_INVENTORY);
            ItemStack scroll = nexus.getStackInSlot(this.index);
            WarpScrollData data = (WarpScrollData)scroll.getOrDefault((Supplier)DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(null, null, null, true));
            if (((Boolean)be.getBlockState().getValue((Property)WarpNexus.REQUIRES_SOURCE)).booleanValue()) {
                List takePos = SourceUtil.takeSourceMultiple((BlockPos)this.pos, (Level)serverPlayer.serverLevel(), (int)5, (int)1000);
                if (takePos != null) {
                    TeleportUtil.teleport(serverPlayer.serverLevel(), data, (Entity)player);
                } else {
                    PortUtil.sendMessageNoSpam((Entity)player, (Component)Component.translatable((String)"ars_nouveau.apparatus.nomana"));
                }
            } else {
                TeleportUtil.teleport(serverPlayer.serverLevel(), data, (Entity)player);
            }
        });
    }

    public static void teleport(int index, BlockPos pos) {
        NetworkHandler.sendToServer(new TeleportNexusPacket(pos, index));
    }
}

