/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.server.util;

import com.github.jarva.arsadditions.ArsAdditions;
import com.github.jarva.arsadditions.setup.config.ServerConfig;
import com.mojang.datafixers.util.Pair;
import java.text.NumberFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;

public class AsyncLocator {
    public static final String CREATE_TASK_MESSAGE = "Creating locate task for {} in {} around {} within {} chunks";
    public static final String ATTEMPT_LOCATE_MESSAGE = "Trying to locate {} in {} around {} within {} chunks";
    public static final String NOT_FOUND_MESSAGE = "No {} found (took {}ms)";
    public static final String FOUND_MESSAGE = "Found {} at {} (took {}ms)";
    private static ExecutorService LOCATING_EXECUTOR_SERVICE = null;

    private AsyncLocator() {
    }

    public static void setupExecutorService() {
        AsyncLocator.shutdownExecutorService();
        int threads = (Integer)ServerConfig.SERVER.locating_threads.get();
        ArsAdditions.LOGGER.info("Starting locating executor service with thread pool size of {}", (Object)threads);
        LOCATING_EXECUTOR_SERVICE = Executors.newFixedThreadPool(threads, new ThreadFactory(){
            private static final AtomicInteger poolNum = new AtomicInteger(1);
            private final AtomicInteger threadNum = new AtomicInteger(1);
            private final String namePrefix = "ars_additions-" + poolNum.getAndIncrement() + "-thread-";

            @Override
            public Thread newThread(@NotNull Runnable r) {
                return new Thread(r, this.namePrefix + this.threadNum.getAndIncrement());
            }
        });
    }

    public static void shutdownExecutorService() {
        if (LOCATING_EXECUTOR_SERVICE != null) {
            ArsAdditions.LOGGER.info("Shutting down locating executor service");
            LOCATING_EXECUTOR_SERVICE.shutdown();
        }
    }

    public static LocateTask<BlockPos> locate(ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        AsyncLocator.logCreateTask(structureTag.toString(), level, pos, searchRadius);
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateLevel(completableFuture, level, structureTag, pos, searchRadius, skipKnownStructures));
        return new LocateTask<BlockPos>(level.getServer(), completableFuture, future);
    }

    public static LocateTask<Pair<BlockPos, Holder<Structure>>> locate(ServerLevel level, HolderSet<Structure> structureSet, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        AsyncLocator.logCreateTask(structureSet.toString(), level, pos, searchRadius);
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateChunkGenerator(completableFuture, level, structureSet, pos, searchRadius, skipKnownStructures));
        return new LocateTask<Pair<BlockPos, Holder<Structure>>>(level.getServer(), completableFuture, future);
    }

    private static void doLocateLevel(CompletableFuture<BlockPos> completableFuture, ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        AsyncLocator.logLocateAttempt(structureTag.toString(), level, pos, searchRadius);
        long start = System.nanoTime();
        BlockPos foundPos = level.findNearestMapStructure(structureTag, pos, searchRadius, skipExistingChunks);
        String time = NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        if (foundPos == null) {
            AsyncLocator.logNotFound(structureTag.toString(), time);
        } else {
            AsyncLocator.logFound(structureTag.toString(), foundPos, time);
        }
        completableFuture.complete(foundPos);
    }

    private static void doLocateChunkGenerator(CompletableFuture<Pair<BlockPos, Holder<Structure>>> completableFuture, ServerLevel level, HolderSet<Structure> structureSet, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        AsyncLocator.logLocateAttempt(structureSet.toString(), level, pos, searchRadius);
        long start = System.nanoTime();
        Pair foundPair = level.getChunkSource().getGenerator().findNearestMapStructure(level, structureSet, pos, searchRadius, skipExistingChunks);
        String time = NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
        if (foundPair == null) {
            AsyncLocator.logNotFound(structureSet.toString(), time);
        } else {
            AsyncLocator.logFound(((Structure)((Holder)foundPair.getSecond()).value()).getClass().getSimpleName(), (BlockPos)foundPair.getFirst(), time);
        }
        completableFuture.complete((Pair<BlockPos, Holder<Structure>>)foundPair);
    }

    private static void logCreateTask(String structure, ServerLevel level, BlockPos pos, int searchRadius) {
        ArsAdditions.LOGGER.debug(CREATE_TASK_MESSAGE, (Object)structure, (Object)level, (Object)pos, (Object)searchRadius);
    }

    private static void logLocateAttempt(String structure, ServerLevel level, BlockPos pos, int searchRadius) {
        ArsAdditions.LOGGER.info(ATTEMPT_LOCATE_MESSAGE, (Object)structure, (Object)level, (Object)pos, (Object)searchRadius);
    }

    private static void logNotFound(String structure, String time) {
        ArsAdditions.LOGGER.info(NOT_FOUND_MESSAGE, (Object)structure, (Object)time);
    }

    private static void logFound(String structure, BlockPos pos, String time) {
        ArsAdditions.LOGGER.info(FOUND_MESSAGE, (Object)structure, (Object)pos.toString(), (Object)time);
    }

    public record LocateTask<T>(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.submit(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

