/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.arsadditions.common.item.data;

import com.github.jarva.arsadditions.setup.registry.AddonDataComponentRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record AdvancedDominionData(Optional<BlockPos> pos, Optional<ResourceKey<Level>> level, Optional<Integer> entityId, Mode mode) {
    public static final Codec<AdvancedDominionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.optionalFieldOf("Pos").forGetter(AdvancedDominionData::pos), (App)Level.RESOURCE_KEY_CODEC.optionalFieldOf("Level").forGetter(AdvancedDominionData::level), (App)Codec.INT.optionalFieldOf("StoredEntity").forGetter(AdvancedDominionData::entityId), (App)StringRepresentable.fromEnum(Mode::values).optionalFieldOf("Mode", (Object)Mode.LOCK_FIRST).forGetter(AdvancedDominionData::mode)).apply((Applicative)instance, AdvancedDominionData::new));
    public static final StreamCodec<ByteBuf, AdvancedDominionData> STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);

    public static AdvancedDominionData fromPos(BlockPos pos, ResourceKey<Level> serverLevel) {
        return new AdvancedDominionData(Optional.of(pos), Optional.of(serverLevel), Optional.empty(), Mode.LOCK_FIRST);
    }

    public static AdvancedDominionData fromEntity(ResourceKey<Level> serverLevel, Entity entity) {
        return new AdvancedDominionData(Optional.empty(), Optional.of(serverLevel), Optional.of(entity.getId()), Mode.LOCK_FIRST);
    }

    @NotNull
    public static AdvancedDominionData fromItemStack(ItemStack stack) {
        return (AdvancedDominionData)stack.getOrDefault((DataComponentType)AddonDataComponentRegistry.ADVANCED_DOMINION_DATA.get(), (Object)new AdvancedDominionData(Optional.empty(), Optional.empty(), Optional.empty(), Mode.LOCK_FIRST));
    }

    public AdvancedDominionData toggleMode() {
        return new AdvancedDominionData(this.pos, this.level, this.entityId, this.mode == Mode.LOCK_FIRST ? Mode.LOCK_SECOND : Mode.LOCK_FIRST);
    }

    @Nullable
    public AdvancedDominionData write(ItemStack stack) {
        return (AdvancedDominionData)stack.set(AddonDataComponentRegistry.ADVANCED_DOMINION_DATA, (Object)this);
    }

    public static enum Mode implements StringRepresentable
    {
        LOCK_FIRST("tooltip.ars_additions.advanced_dominion_wand.mode.first"),
        LOCK_SECOND("tooltip.ars_additions.advanced_dominion_wand.mode.second");

        private final String translatable;

        private Mode(String translatable) {
            this.translatable = translatable;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase();
        }

        public Component getTranslatable() {
            return Component.translatable((String)this.translatable);
        }
    }
}

