/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.appflux.common.me.strategy;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import com.glodblock.github.appflux.common.me.key.FluxKey;
import com.glodblock.github.appflux.common.me.key.type.EnergyType;
import com.glodblock.github.appflux.common.me.key.type.FluxKeyType;
import com.glodblock.github.appflux.util.AFUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class FEStackImportStrategy
implements StackImportStrategy {
    private final BlockCapabilityCache<? extends IEnergyStorage, Direction> apiCache;

    public FEStackImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    public boolean transfer(StackTransferContext context) {
        if (!context.isKeyTypeEnabled((AEKeyType)FluxKeyType.TYPE)) {
            return false;
        }
        IEnergyStorage adjacentHandler = (IEnergyStorage)this.apiCache.getCapability();
        FluxKey resource = FluxKey.of(EnergyType.FE);
        if (adjacentHandler == null) {
            return false;
        }
        if (!context.isInFilter((AEKey)resource)) {
            return false;
        }
        long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)FluxKeyType.TYPE.getAmountPerOperation();
        IStorageService inv = context.getInternalStorage();
        long toExt = inv.getInventory().insert((AEKey)resource, remainingTransferAmount, Actionable.SIMULATE, context.getActionSource());
        if ((toExt = (long)adjacentHandler.extractEnergy(AFUtil.clampLong(toExt), true)) > 0L) {
            int realExt = adjacentHandler.extractEnergy(AFUtil.clampLong(toExt), false);
            long realAdd = inv.getInventory().insert((AEKey)resource, (long)realExt, Actionable.MODULATE, context.getActionSource());
            if (realAdd < (long)realExt) {
                adjacentHandler.receiveEnergy((int)((long)realExt - realAdd), false);
            }
            long opsUsed = Math.max(1L, realAdd / (long)FluxKeyType.TYPE.getAmountPerOperation());
            context.reduceOperationsRemaining(opsUsed);
        }
        return false;
    }
}

