/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.instancing;

import dev.djefrey.colorwheel.engine.ClrwlAbstractInstancer;
import dev.djefrey.colorwheel.engine.ClrwlBaseInstancer;
import dev.djefrey.colorwheel.engine.ClrwlInstanceHandle;
import dev.djefrey.colorwheel.engine.ClrwlInstancerKey;
import dev.djefrey.colorwheel.instancing.ClrwlInstancedDraw;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstanceWriter;
import dev.engine_room.flywheel.api.layout.Layout;
import dev.engine_room.flywheel.backend.gl.TextureBuffer;
import dev.engine_room.flywheel.backend.gl.buffer.GlBuffer;
import dev.engine_room.flywheel.backend.gl.buffer.GlBufferUsage;
import dev.engine_room.flywheel.lib.math.MoreMath;
import dev.engine_room.flywheel.lib.memory.MemoryBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ClrwlInstancedInstancer<I extends Instance>
extends ClrwlBaseInstancer<I> {
    private final int instanceStride;
    private final InstanceWriter<I> writer;
    @Nullable
    private GlBuffer vbo;
    private final List<ClrwlInstancedDraw> draws = new ArrayList<ClrwlInstancedDraw>();

    public ClrwlInstancedInstancer(ClrwlInstancerKey<I> key, ClrwlAbstractInstancer.Recreate<I> recreate) {
        super(key, recreate);
        Layout layout = this.type.layout();
        this.instanceStride = MoreMath.align16((int)layout.byteSize());
        this.writer = this.type.writer();
    }

    public List<ClrwlInstancedDraw> draws() {
        return this.draws;
    }

    public void init() {
        if (this.vbo != null) {
            return;
        }
        this.vbo = new GlBuffer(GlBufferUsage.DYNAMIC_DRAW);
    }

    public void updateBuffer() {
        if (this.changed.isEmpty() || this.vbo == null) {
            return;
        }
        int byteSize = this.instanceStride * this.instances.size();
        if (this.needsToGrow(byteSize)) {
            MemoryBlock temp = MemoryBlock.malloc((long)this.increaseSize(byteSize));
            this.writeAll(temp.ptr());
            this.vbo.upload(temp);
            temp.free();
        } else {
            this.writeChanged();
        }
        this.changed.clear();
    }

    private void writeChanged() {
        this.changed.forEachSetSpan((startInclusive, endInclusive) -> {
            if (startInclusive >= this.instances.size()) {
                return;
            }
            int actualEnd = Math.min(endInclusive, this.instances.size() - 1);
            MemoryBlock temp = MemoryBlock.malloc((long)((long)this.instanceStride * (long)(actualEnd - startInclusive + 1)));
            long ptr = temp.ptr();
            for (int i = startInclusive; i <= actualEnd; ++i) {
                this.writer.write(ptr, (Instance)this.instances.get(i));
                ptr += (long)this.instanceStride;
            }
            this.vbo.uploadSpan((long)startInclusive * (long)this.instanceStride, temp);
            temp.free();
        });
    }

    private void writeAll(long ptr) {
        for (Instance instance : this.instances) {
            this.writer.write(ptr, instance);
            ptr += (long)this.instanceStride;
        }
    }

    private long increaseSize(long capacity) {
        return Math.max(capacity + (long)this.instanceStride * 16L, (long)((double)capacity * 1.6));
    }

    public boolean needsToGrow(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Size " + capacity + " < 0");
        }
        if (capacity == 0L) {
            return false;
        }
        return capacity > this.vbo.size();
    }

    @Override
    public void parallelUpdate() {
        int removeCount;
        if (this.deleted.isEmpty()) {
            return;
        }
        int oldSize = this.instances.size();
        if (oldSize == (removeCount = this.deleted.cardinality())) {
            this.clear();
            return;
        }
        int newSize = oldSize - removeCount;
        int writePos = this.deleted.nextSetBit(0);
        if (writePos < newSize) {
            this.changed.set(writePos, newSize);
        }
        this.changed.clear(newSize, oldSize);
        for (int scanPos = writePos; scanPos < oldSize && writePos < newSize; ++scanPos, ++writePos) {
            if ((scanPos = this.deleted.nextClearBit(scanPos)) == writePos) continue;
            ClrwlInstanceHandle handle = (ClrwlInstanceHandle)this.handles.get(scanPos);
            Instance instance = (Instance)this.instances.get(scanPos);
            this.handles.set(writePos, handle);
            this.instances.set(writePos, instance);
            handle.index = writePos;
        }
        this.deleted.clear();
        this.instances.subList(newSize, oldSize).clear();
        this.handles.subList(newSize, oldSize).clear();
    }

    @Override
    public void delete() {
        if (this.vbo == null) {
            return;
        }
        this.vbo.delete();
        this.vbo = null;
        for (ClrwlInstancedDraw instancedDraw : this.draws) {
            instancedDraw.delete();
        }
    }

    public void addDrawCall(ClrwlInstancedDraw instancedDraw) {
        this.draws.add(instancedDraw);
    }

    public void bind(TextureBuffer buffer) {
        if (this.vbo == null) {
            return;
        }
        buffer.bind(this.vbo.handle());
    }
}

