/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.accessors.IrisRenderingPipelineAccessor;
import dev.djefrey.colorwheel.accessors.ProgramSetAccessor;
import dev.djefrey.colorwheel.compile.ClrwlPrograms;
import dev.djefrey.colorwheel.engine.ClrwlInstanceVisual;
import dev.djefrey.colorwheel.engine.ClrwlInstancerProvider;
import dev.djefrey.colorwheel.engine.ShadowRenderContext;
import dev.djefrey.colorwheel.engine.ShadowRenderingPhase;
import dev.djefrey.colorwheel.engine.embed.EmbeddedEnvironment;
import dev.djefrey.colorwheel.engine.embed.EnvironmentStorage;
import dev.djefrey.colorwheel.engine.uniform.ClrwlUniforms;
import dev.djefrey.colorwheel.instancing.ClrwlInstancedDrawManager;
import dev.engine_room.flywheel.api.backend.Engine;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.instance.InstanceType;
import dev.engine_room.flywheel.api.instance.Instancer;
import dev.engine_room.flywheel.api.instance.InstancerProvider;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.task.Plan;
import dev.engine_room.flywheel.api.visualization.VisualEmbedding;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.backend.compile.FlwPrograms;
import dev.engine_room.flywheel.backend.engine.LightStorage;
import dev.engine_room.flywheel.backend.engine.embed.Environment;
import dev.engine_room.flywheel.backend.gl.GlStateTracker;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class ClrwlEngine
implements Engine {
    public static Map<IrisRenderingPipeline, ClrwlEngine> ENGINES = new HashMap<IrisRenderingPipeline, ClrwlEngine>();
    private final ClrwlInstancedDrawManager drawManager;
    private final int sqrMaxOriginDistance;
    private final EnvironmentStorage environmentStorage;
    private final LightStorage lightStorage;
    private BlockPos renderOrigin = BlockPos.ZERO;
    private final LevelAccessor level;
    private final NamespacedId dimension;
    private final IrisRenderingPipeline irisPipeline;
    private final ShaderPack pack;

    public ClrwlEngine(LevelAccessor level, int maxOriginDistance) {
        ClientLevel clientLevel = (ClientLevel)level;
        this.level = level;
        this.dimension = new NamespacedId(clientLevel.dimension().location().getNamespace(), clientLevel.dimension().location().getPath());
        WorldRenderingPipeline worldPipeline = Iris.getPipelineManager().preparePipeline(this.dimension);
        this.irisPipeline = (IrisRenderingPipeline)worldPipeline;
        this.pack = (ShaderPack)Iris.getCurrentPack().orElseThrow();
        ProgramSet programSet = this.pack.getProgramSet(this.dimension);
        boolean isFallback = ((ProgramSetAccessor)programSet).colorwheel$isFallbackMode();
        ClrwlPrograms programs = ClrwlPrograms.build(FlwPrograms.SOURCES, this.pack, this.dimension, isFallback);
        this.drawManager = new ClrwlInstancedDrawManager(this.dimension, this.irisPipeline, this.pack, programs);
        this.sqrMaxOriginDistance = maxOriginDistance * maxOriginDistance;
        this.environmentStorage = new EnvironmentStorage();
        this.lightStorage = new LightStorage(level);
        ((IrisRenderingPipelineAccessor)this.irisPipeline).colorwheel$setBeginTranslucentsCallback(this.drawManager::renderTranslucent);
        ENGINES.put(this.irisPipeline, this);
    }

    public VisualizationContext createVisualizationContext() {
        return new ClrwlMainVisualizationContext();
    }

    public Plan<RenderContext> createFramePlan() {
        return this.drawManager.createFramePlan().and(this.lightStorage.createFramePlan());
    }

    public Vec3i renderOrigin() {
        return this.renderOrigin;
    }

    public boolean updateRenderOrigin(Camera camera) {
        double dz;
        double dy;
        Vec3 cameraPos = camera.getPosition();
        double dx = (double)this.renderOrigin.getX() - cameraPos.x;
        double distanceSqr = dx * dx + (dy = (double)this.renderOrigin.getY() - cameraPos.y) * dy + (dz = (double)this.renderOrigin.getZ() - cameraPos.z) * dz;
        if (distanceSqr <= (double)this.sqrMaxOriginDistance) {
            return false;
        }
        this.renderOrigin = BlockPos.containing((Position)cameraPos);
        this.drawManager.onRenderOriginChanged();
        return true;
    }

    public void lightSections(LongSet longSet) {
        this.lightStorage.sections(longSet);
    }

    public void onLightUpdate(SectionPos sectionPos, LightLayer lightLayer) {
        this.lightStorage.onLightUpdate(sectionPos.asLong());
    }

    public void render(RenderContext context) {
        try (GlStateTracker.State state = GlStateTracker.getRestoreState();){
            if (context instanceof ShadowRenderContext) {
                ShadowRenderContext shadowContext = (ShadowRenderContext)context;
                if (shadowContext.phase() == ShadowRenderingPhase.SOLID) {
                    ClrwlUniforms.update(context, this.pack, this.dimension);
                    this.environmentStorage.flush();
                    this.drawManager.prepareFrame(this.lightStorage, this.environmentStorage);
                    this.drawManager.renderSolid();
                } else {
                    this.drawManager.renderTranslucent();
                }
            } else {
                ClrwlUniforms.update(context, this.pack, this.dimension);
                this.environmentStorage.flush();
                this.drawManager.prepareFrame(this.lightStorage, this.environmentStorage);
                this.drawManager.renderSolid();
            }
        }
        catch (Exception e) {
            Colorwheel.LOGGER.error("Falling back", (Throwable)e);
            this.drawManager.triggerFallback();
        }
    }

    public void renderCrumbling(RenderContext renderContext, List<Engine.CrumblingBlock> crumblingBlocks) {
        try (GlStateTracker.State state = GlStateTracker.getRestoreState();){
            this.drawManager.renderCrumbling(crumblingBlocks);
        }
        catch (Exception e) {
            Colorwheel.LOGGER.error("Falling back", (Throwable)e);
            this.drawManager.triggerFallback();
        }
    }

    public void delete() {
        ENGINES.remove(this.irisPipeline);
        ((IrisRenderingPipelineAccessor)this.irisPipeline).colorwheel$setBeginTranslucentsCallback(null);
        this.drawManager.delete();
        this.lightStorage.delete();
        this.environmentStorage.delete();
    }

    public EnvironmentStorage environmentStorage() {
        return this.environmentStorage;
    }

    public LightStorage lightStorage() {
        return this.lightStorage;
    }

    public LevelAccessor level() {
        return this.level;
    }

    public <I extends Instance> Instancer<I> instancer(ClrwlInstanceVisual visual, Environment environment, InstanceType<I> type, Model model, int bias) {
        return this.drawManager.getInstancer(visual, environment, type, model, bias);
    }

    public class ClrwlMainVisualizationContext
    implements VisualizationContext {
        private final ClrwlInstancerProvider instancerProvider;
        private final Map<ClrwlBlockEntityVisualizationContext.Key, ClrwlBlockEntityVisualizationContext> blockEntityCtxs = new HashMap<ClrwlBlockEntityVisualizationContext.Key, ClrwlBlockEntityVisualizationContext>();
        private final Map<Integer, ClrwlEntityVisualizationContext> entityCtxs = new HashMap<Integer, ClrwlEntityVisualizationContext>();

        public ClrwlMainVisualizationContext() {
            this.instancerProvider = new ClrwlInstancerProvider(ClrwlEngine.this, ClrwlInstanceVisual.undefined());
        }

        public VisualizationContext getBlockEntityVisualCtx(int irisId, int lightEmission) {
            return this.blockEntityCtxs.computeIfAbsent(new ClrwlBlockEntityVisualizationContext.Key(irisId, lightEmission), x$0 -> new ClrwlBlockEntityVisualizationContext((ClrwlBlockEntityVisualizationContext.Key)x$0));
        }

        public VisualizationContext getEntityVisualCtx(int irisId) {
            return this.entityCtxs.computeIfAbsent(irisId, x$0 -> new ClrwlEntityVisualizationContext((int)x$0));
        }

        public InstancerProvider instancerProvider() {
            return this.instancerProvider;
        }

        public Vec3i renderOrigin() {
            return ClrwlEngine.this.renderOrigin();
        }

        public VisualEmbedding createEmbedding(Vec3i renderOrigin) {
            EmbeddedEnvironment out = new EmbeddedEnvironment(ClrwlEngine.this, ClrwlInstanceVisual.undefined(), renderOrigin);
            ClrwlEngine.this.environmentStorage.track(out);
            return out;
        }
    }

    private class ClrwlEntityVisualizationContext
    implements VisualizationContext {
        private final int irisId;
        private final ClrwlInstancerProvider instancerProvider;

        public ClrwlEntityVisualizationContext(int irisId) {
            this.irisId = irisId;
            this.instancerProvider = new ClrwlInstancerProvider(ClrwlEngine.this, ClrwlInstanceVisual.entity(irisId));
        }

        public InstancerProvider instancerProvider() {
            return this.instancerProvider;
        }

        public Vec3i renderOrigin() {
            return ClrwlEngine.this.renderOrigin();
        }

        public VisualEmbedding createEmbedding(Vec3i renderOrigin) {
            EmbeddedEnvironment out = new EmbeddedEnvironment(ClrwlEngine.this, ClrwlInstanceVisual.entity(this.irisId), renderOrigin);
            ClrwlEngine.this.environmentStorage.track(out);
            return out;
        }
    }

    private class ClrwlBlockEntityVisualizationContext
    implements VisualizationContext {
        private final int irisId;
        private final int lightEmission;
        private final ClrwlInstancerProvider instancerProvider;

        public ClrwlBlockEntityVisualizationContext(Key key) {
            this.irisId = key.irisId;
            this.lightEmission = key.lightEmission;
            this.instancerProvider = new ClrwlInstancerProvider(ClrwlEngine.this, ClrwlInstanceVisual.blockEntity(this.irisId, this.lightEmission));
        }

        public InstancerProvider instancerProvider() {
            return this.instancerProvider;
        }

        public Vec3i renderOrigin() {
            return ClrwlEngine.this.renderOrigin();
        }

        public VisualEmbedding createEmbedding(Vec3i renderOrigin) {
            EmbeddedEnvironment out = new EmbeddedEnvironment(ClrwlEngine.this, ClrwlInstanceVisual.blockEntity(this.irisId, this.lightEmission), renderOrigin);
            ClrwlEngine.this.environmentStorage.track(out);
            return out;
        }

        record Key(int irisId, int lightEmission) {
        }
    }
}

