/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy.utils;

import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.sixik.sdmeconomy.SDMEconomy;
import net.sixik.sdmeconomy.api.CustomCurrencies;
import net.sixik.sdmeconomy.data.CustomPlayerData;
import net.sixik.sdmeconomy.economy.Currency;
import net.sixik.sdmeconomy.economyData.CurrenciesIO;
import net.sixik.sdmeconomy.economyData.CurrencyData;
import net.sixik.sdmeconomy.economyData.CurrencyPlayerData;
import net.sixik.sdmeconomy.network.SDMEconomyNetwork;
import net.sixik.sdmeconomy.network.packages.client.SendCurrenciesS2C;
import net.sixik.sdmeconomy.network.packages.client.SendCustomDataS2C;
import net.sixik.sdmeconomy.network.packages.client.SendPlayerCurrenciesS2C;
import net.sixik.sdmeconomy.network.packages.server.SendCreateCurrencyC2S;
import net.sixik.sdmeconomy.network.packages.server.SendDeleteCurrencyC2S;
import net.sixik.sdmeconomy.utils.ErrorCodeStruct;
import net.sixik.sdmeconomy.utils.ErrorCodes;

public class CurrencyHelper {
    public static Executor executor = Executors.newSingleThreadExecutor();

    public static ErrorCodeStruct<CurrencyData> getAllCurrency() {
        if (CurrencyData.SERVER != null) {
            return new ErrorCodeStruct<CurrencyData>(CurrencyData.SERVER, ErrorCodes.SUCCESS);
        }
        if (CurrencyData.CLIENT != null) {
            return new ErrorCodeStruct<CurrencyData>(CurrencyData.CLIENT, ErrorCodes.SUCCESS);
        }
        return new ErrorCodeStruct<Object>(null, ErrorCodes.FAIL);
    }

    public static ErrorCodes syncPlayer(ServerPlayer player) {
        try {
            CurrencyHelper.syncCurrencyData(player);
            CurrencyHelper.syncCustomData(player);
            SDMEconomyNetwork.sendTo(player, new SendPlayerCurrenciesS2C((Player)player));
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("Error when try sync player currency", e);
            return ErrorCodes.FAIL;
        }
        return ErrorCodes.SUCCESS;
    }

    public static ErrorCodeStruct<CurrencyData> getCurrencyData(boolean isClient) {
        try {
            if (isClient) {
                if (CurrencyData.CLIENT == null) {
                    return new ErrorCodeStruct<Object>(null, ErrorCodes.FAIL);
                }
                return new ErrorCodeStruct<CurrencyData>(CurrencyData.CLIENT, ErrorCodes.FAIL);
            }
            if (CurrencyData.SERVER == null) {
                return new ErrorCodeStruct<Object>(null, ErrorCodes.FAIL);
            }
            return new ErrorCodeStruct<CurrencyData>(CurrencyData.SERVER, ErrorCodes.FAIL);
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("Error when try get currency data", e);
            return new ErrorCodeStruct<Object>(null, ErrorCodes.FAIL);
        }
    }

    public static ErrorCodeStruct<LinkedList<CurrencyPlayerData.PlayerCurrency>> getCurrencyPlayerData(Player player) {
        try {
            if (CurrencyPlayerData.SERVER != null) {
                return new ErrorCodeStruct<LinkedList<CurrencyPlayerData.PlayerCurrency>>(CurrencyPlayerData.SERVER.getPlayersCurrency(player));
            }
            if (CurrencyPlayerData.CLIENT != null) {
                return new ErrorCodeStruct<LinkedList<CurrencyPlayerData.PlayerCurrency>>(CurrencyPlayerData.CLIENT.currencies);
            }
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("Error when try get currency for player " + String.valueOf(player.getGameProfile().getId()), e);
            return new ErrorCodeStruct<LinkedList<CurrencyPlayerData.PlayerCurrency>>(new LinkedList(), ErrorCodes.FAIL);
        }
        return new ErrorCodeStruct<LinkedList<CurrencyPlayerData.PlayerCurrency>>(new LinkedList(), ErrorCodes.NOT_FOUND);
    }

    public static CurrencyPlayerData.Server getPlayerCurrencyServerData() {
        return CurrencyPlayerData.SERVER;
    }

    public static CurrencyPlayerData.Client getPlayerCurrencyClientData() {
        return CurrencyPlayerData.CLIENT;
    }

    public static void syncCurrencyData(ServerPlayer player) {
        SDMEconomyNetwork.sendTo(player, new SendCurrenciesS2C(CurrenciesIO.saveToNBT(CurrencyData.SERVER.currencies)));
    }

    public static void syncCurrencyData(MinecraftServer server) {
        SDMEconomyNetwork.sendToAll(server, new SendCurrenciesS2C(CurrenciesIO.saveToNBT(CurrencyData.SERVER.currencies)));
    }

    public static void createCurrencyOnClient(Currency currency) {
        SDMEconomyNetwork.sendToServer(new SendCreateCurrencyC2S(currency));
    }

    public static ErrorCodes createCurrencyOnServer(Currency currency) {
        if (CurrencyData.SERVER == null) {
            return ErrorCodes.FAIL;
        }
        CurrencyData.SERVER.currencies.add(currency);
        for (Map.Entry<UUID, LinkedList<CurrencyPlayerData.PlayerCurrency>> entry : CurrencyPlayerData.SERVER.playersCurrencyMap.entrySet()) {
            entry.getValue().add(new CurrencyPlayerData.PlayerCurrency(currency.copy(), currency.getDefaultValue()));
        }
        CurrencyHelper.saveAll(CurrencyData.SERVER.server);
        return ErrorCodes.SUCCESS;
    }

    public static void deleteCurrencyOnClient(Currency currency) {
        SDMEconomyNetwork.sendToServer(new SendDeleteCurrencyC2S(currency));
    }

    public static ErrorCodes deleteCurrencyOnServer(Currency currency) {
        if (CurrencyData.SERVER == null) {
            return ErrorCodes.FAIL;
        }
        CurrencyData.SERVER.currencies.removeIf(s -> s.getName().equals(currency.getName()));
        for (Map.Entry<UUID, LinkedList<CurrencyPlayerData.PlayerCurrency>> entry : CurrencyPlayerData.SERVER.playersCurrencyMap.entrySet()) {
            entry.getValue().removeIf(s -> s.currency.getName().equals(currency.getName()));
        }
        CurrencyHelper.saveAll(CurrencyData.SERVER.server);
        return ErrorCodes.SUCCESS;
    }

    public static ErrorCodes syncCurrencyFromServerToClient(MinecraftServer server) {
        if (CurrencyData.SERVER == null) {
            return ErrorCodes.FAIL;
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            SDMEconomyNetwork.sendTo(player, new SendPlayerCurrenciesS2C((Player)player));
        }
        return ErrorCodes.SUCCESS;
    }

    public static UUID getPlayerUUID(Player player) {
        return player.getGameProfile().getId();
    }

    public static boolean isAdmin(Player player) {
        return player.hasPermissions(3);
    }

    public static void saveAll(MinecraftServer server) {
        CurrencyHelper.saveCurrencyData();
        CurrencyHelper.savePlayerData(server);
        CustomPlayerData.SERVER.save(server.getWorldPath(LevelResource.ROOT));
    }

    public static void saveCurrencyData() {
        CurrenciesIO.save(Platform.getConfigFolder(), CurrencyData.SERVER.currencies);
    }

    public static void savePlayerData(MinecraftServer server) {
        CurrenciesIO.savePlayersData(server.getWorldPath(LevelResource.ROOT), CurrencyPlayerData.SERVER.playersCurrencyMap);
    }

    public static ErrorCodeStruct<Boolean> checkNewCurrency() {
        try {
            ArrayList<Currency> check = new ArrayList<Currency>();
            ArrayList<Currency> notFounded = new ArrayList<Currency>();
            for (Supplier<Currency> supplier : CustomCurrencies.CURRENCIES.values()) {
                check.add(supplier.get());
            }
            for (Currency currency : check) {
                if (!CurrencyData.SERVER.currencies.stream().noneMatch(c -> c.getName().equals(currency1.getName()))) continue;
                notFounded.add(currency.copy());
            }
            CurrencyData.SERVER.currencies.addAll(notFounded);
            for (Map.Entry entry : CurrencyPlayerData.SERVER.playersCurrencyMap.entrySet()) {
                notFounded = new ArrayList();
                for (Currency currency1 : check) {
                    if (!((LinkedList)entry.getValue()).stream().noneMatch(c -> c.currency.getName().equals(currency1.getName()))) continue;
                    notFounded.add(currency1.copy());
                }
                if (notFounded.isEmpty()) continue;
                ((LinkedList)entry.getValue()).addAll(notFounded.stream().map(s -> new CurrencyPlayerData.PlayerCurrency((Currency)s, s.getDefaultValue())).toList());
            }
            return new ErrorCodeStruct<Boolean>(true, ErrorCodes.SUCCESS);
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("Error when check new currency", e);
            return new ErrorCodeStruct<Boolean>(false, ErrorCodes.FAIL);
        }
    }

    public static CustomPlayerData.Server getCustomServerData() {
        return CustomPlayerData.SERVER;
    }

    public static CustomPlayerData.Client getCustomClientData() {
        return CustomPlayerData.CLIENT;
    }

    public static void syncCustomData(ServerPlayer player) {
        SDMEconomyNetwork.sendTo(player, new SendCustomDataS2C(CurrencyHelper.getPlayerUUID((Player)player)));
    }

    public static ErrorCodes updateCustomData(ServerPlayer player, Consumer<CompoundTag> nbt) {
        try {
            CustomPlayerData.Data data = CurrencyHelper.getCustomServerData().getPlayerCustomData((Player)player);
            nbt.accept(data.nbt);
            SDMEconomyNetwork.sendTo(player, new SendCustomDataS2C(CurrencyHelper.getPlayerUUID((Player)player)));
            return ErrorCodes.SUCCESS;
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("Error when update custom data", e);
            return ErrorCodes.FAIL;
        }
    }

    public static CompoundTag getCustomData(Player player) {
        if (player.isLocalPlayer()) {
            return CurrencyHelper.getCustomClientData().data.nbt;
        }
        return CurrencyHelper.getCustomServerData().getPlayerCustomData((Player)player).nbt;
    }
}

