/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy.network.ASK;

import dev.architectury.event.events.common.LifecycleEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdmeconomy.network.ASK.ASK_base.DataSyncASKC2S;
import net.sixik.sdmeconomy.network.ASK.ASK_base.DataSyncASKS2C;
import net.sixik.sdmeconomy.network.SDMEconomyNetwork;

public class ASKHandler {
    public static final long WAIT_TIME = 1L;
    public static final long TIME_OUT = 800L;
    private static volatile ASKHandler instance;
    protected Thread executor;
    protected Map<UUID, Request> requests = new ConcurrentHashMap<UUID, Request>();
    protected MinecraftServer server;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ASKHandler getInstance() {
        if (instance != null) return instance;
        Class<ASKHandler> clazz = ASKHandler.class;
        synchronized (ASKHandler.class) {
            if (instance != null) return instance;
            throw new IllegalStateException("ACKHandler not initialized");
        }
    }

    public ASKHandler(MinecraftServer server) {
        this.server = server;
        this.executor = new Thread(() -> {
            while (!Thread.interrupted()) {
                try {
                    this.tick();
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }, "ACK Thread");
        LifecycleEvent.SERVER_STOPPED.register(s -> this.executor.interrupt());
        this.executor.start();
        instance = this;
    }

    public void addRequests(Player player, Data ... nbt) {
        this.addRequests(player.getGameProfile().getId(), nbt);
    }

    public void addRequests(UUID player, Data ... nbt) {
        Request request = this.requests.computeIfAbsent(player, k -> new Request(new ConcurrentLinkedQueue<Data>()));
        request.runnables().addAll(Arrays.asList(nbt));
    }

    public Optional<Request> getNextRequest(Player player) {
        return this.getNextRequest(player.getGameProfile().getId());
    }

    public Optional<Request> getNextRequest(UUID player) {
        return Optional.ofNullable(this.requests.get(player));
    }

    public void tick() {
        Iterator<Map.Entry<UUID, Request>> iterator = this.requests.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Request> entry = iterator.next();
            UUID playerId = entry.getKey();
            Request request = entry.getValue();
            if (!request.waitRequest) {
                Data value = request.runnables.poll();
                if (value == null) continue;
                Optional<ServerPlayer> opt = this.getPlayer(playerId);
                if (opt.isEmpty()) {
                    iterator.remove();
                    continue;
                }
                opt.ifPresent(serverPlayer -> this.server.execute(() -> {
                    request.startTime(System.currentTimeMillis());
                    request.waitRequest(true);
                    SDMEconomyNetwork.sendTo(serverPlayer, new DataSyncASKS2C(value.id, value.data));
                }));
                continue;
            }
            if (System.currentTimeMillis() - request.startTime < 800L) continue;
            request.waitRequest(false);
        }
    }

    protected Optional<ServerPlayer> getPlayer(UUID uuid) {
        return this.server.getPlayerList().getPlayers().stream().filter(s -> s.getGameProfile().getId().equals(uuid)).findFirst();
    }

    public static void sendToServer(Data data) {
        SDMEconomyNetwork.sendToServer(new DataSyncASKC2S(data.id, data.data));
    }

    public static void sendToClient(ServerPlayer player, Data data) {
        ASKHandler.getInstance().addRequests((Player)player, data);
    }

    public record Data(String id, CompoundTag data) {
    }

    public static final class Request {
        private final ConcurrentLinkedQueue<Data> runnables;
        public volatile boolean waitRequest = false;
        public long startTime;

        public Request(ConcurrentLinkedQueue<Data> runnables) {
            this.runnables = runnables;
        }

        public Request waitRequest(boolean value) {
            this.waitRequest = value;
            return this;
        }

        public Request startTime(long time) {
            this.startTime = time;
            return this;
        }

        public ConcurrentLinkedQueue<Data> runnables() {
            return this.runnables;
        }
    }
}

