/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy.economyData;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.sixik.sdmeconomy.api.IIntegrationCurrency;
import net.sixik.sdmeconomy.economy.Currency;
import net.sixik.sdmeconomy.economyData.CurrenciesIO;
import net.sixik.sdmeconomy.economyData.CurrencyData;
import net.sixik.sdmeconomy.integrations.impactor.ImpactorCurrency;
import net.sixik.sdmeconomy.utils.CurrencyHelper;
import net.sixik.sdmeconomy.utils.ErrorCodeStruct;
import net.sixik.sdmeconomy.utils.ErrorCodes;

public class CurrencyPlayerData {
    public static Server SERVER;
    public static Client CLIENT;

    public static void load(MinecraftServer server) {
        SERVER = new Server();
        CurrencyPlayerData.SERVER.server = server;
        CurrencyPlayerData.SERVER.playersCurrencyMap = CurrenciesIO.loadPlayersData(server.getWorldPath(LevelResource.ROOT));
    }

    public static void save(MinecraftServer server) {
        if (SERVER == null) {
            throw new IllegalStateException("CurrencyData.SERVER is null");
        }
        CurrenciesIO.savePlayersData(server.getWorldPath(LevelResource.ROOT), CurrencyPlayerData.SERVER.playersCurrencyMap);
    }

    static {
        CLIENT = new Client();
    }

    public static class Server {
        public MinecraftServer server;
        public Map<UUID, LinkedList<PlayerCurrency>> playersCurrencyMap = new HashMap<UUID, LinkedList<PlayerCurrency>>();

        public ErrorCodes addCurrencyValue(Player player, String currencyName, double value) {
            return this.addCurrencyValue(CurrencyHelper.getPlayerUUID(player), currencyName, value);
        }

        public ErrorCodes addCurrencyValue(UUID uuid, String currencyName, double value) {
            LinkedList<PlayerCurrency> playerCurrencies = this.getPlayersCurrency(uuid);
            Optional<PlayerCurrency> currencyOpt = playerCurrencies.stream().filter(c -> c.currency.getName().equalsIgnoreCase(currencyName)).findFirst();
            if (currencyOpt.isPresent()) {
                PlayerCurrency cur = currencyOpt.get();
                Currency currency = cur.currency;
                if (currency instanceof IIntegrationCurrency) {
                    IIntegrationCurrency iIntegrationCurrency = (IIntegrationCurrency)((Object)currency);
                    iIntegrationCurrency.addCurrency(uuid, value);
                    currencyOpt.get().balance = iIntegrationCurrency.getCurrency(uuid);
                } else {
                    currencyOpt.get().balance += value;
                }
                CurrencyPlayerData.save(this.server);
                return ErrorCodes.SUCCESS;
            }
            return ErrorCodes.NOT_FOUND;
        }

        public ErrorCodes setCurrencyValue(Player player, String currencyName, double value) {
            return this.setCurrencyValue(CurrencyHelper.getPlayerUUID(player), currencyName, value);
        }

        public ErrorCodes setCurrencyValue(UUID player, String currencyName, double value) {
            LinkedList<PlayerCurrency> playerCurrencies = this.getPlayersCurrency(player);
            Optional<PlayerCurrency> currencyOpt = playerCurrencies.stream().filter(c -> c.currency.getName().equalsIgnoreCase(currencyName)).findFirst();
            if (currencyOpt.isPresent()) {
                PlayerCurrency cur = currencyOpt.get();
                Currency currency = cur.currency;
                if (currency instanceof ImpactorCurrency) {
                    ImpactorCurrency impactorCurrency = (ImpactorCurrency)currency;
                    impactorCurrency.setCurrency(player, value);
                    currencyOpt.get().balance = impactorCurrency.getCurrency(player);
                } else {
                    currencyOpt.get().balance = value;
                }
                CurrencyPlayerData.save(this.server);
                return ErrorCodes.SUCCESS;
            }
            return ErrorCodes.NOT_FOUND;
        }

        public ErrorCodeStruct<Double> getBalance(Player player, String currencyName) {
            return this.getBalance(CurrencyHelper.getPlayerUUID(player), currencyName);
        }

        public ErrorCodeStruct<Double> getBalance(UUID player, String currencyName) {
            LinkedList<PlayerCurrency> playerCurrencies = this.getPlayersCurrency(player);
            Optional<PlayerCurrency> currencyOpt = playerCurrencies.stream().filter(c -> c.currency.getName().equalsIgnoreCase(currencyName)).findFirst();
            if (currencyOpt.isPresent()) {
                PlayerCurrency cur = currencyOpt.get();
                Currency currency = cur.currency;
                if (currency instanceof ImpactorCurrency) {
                    ImpactorCurrency impactorCurrency = (ImpactorCurrency)currency;
                    return new ErrorCodeStruct<Double>(impactorCurrency.getCurrency(player), ErrorCodes.SUCCESS);
                }
                return new ErrorCodeStruct<Double>(cur.balance, ErrorCodes.SUCCESS);
            }
            return new ErrorCodeStruct<Double>(0.0, ErrorCodes.NOT_FOUND);
        }

        public LinkedList<PlayerCurrency> getPlayersCurrency(Player player) {
            return this.getPlayersCurrency(CurrencyHelper.getPlayerUUID(player));
        }

        public LinkedList<PlayerCurrency> getPlayersCurrency(UUID playerID) {
            if (!this.playersCurrencyMap.containsKey(playerID)) {
                SERVER.newPlayer(playerID);
            }
            return this.playersCurrencyMap.computeIfAbsent(playerID, k -> new LinkedList());
        }

        public Optional<PlayerCurrency> getPlayerCurrency(Player player, String currencyName) {
            return this.getPlayerCurrency(CurrencyHelper.getPlayerUUID(player), currencyName);
        }

        public Optional<PlayerCurrency> getPlayerCurrency(UUID playerID, String currencyName) {
            return this.getPlayersCurrency(playerID).stream().filter(c -> c.currency.getName().equalsIgnoreCase(currencyName)).findFirst();
        }

        public LinkedList<PlayerCurrency> getPlayerUnlockedCurrency(Player player) {
            return this.getPlayersCurrency(CurrencyHelper.getPlayerUUID(player));
        }

        public LinkedList<PlayerCurrency> getPlayerUnlockedCurrency(UUID player) {
            return this.getPlayersCurrency(player).stream().filter(c -> !c.isLocked).collect(Collectors.toCollection(LinkedList::new));
        }

        public LinkedList<PlayerCurrency> getPlayerLockedCurrency(Player player) {
            return this.getPlayersCurrency(CurrencyHelper.getPlayerUUID(player));
        }

        public LinkedList<PlayerCurrency> getPlayerLockedCurrency(UUID player) {
            return this.getPlayersCurrency(player).stream().filter(c -> c.isLocked).collect(Collectors.toCollection(LinkedList::new));
        }

        public ErrorCodes lockCurrency(Player player, String currencyName, boolean value) {
            return this.lockCurrency(CurrencyHelper.getPlayerUUID(player), currencyName, value);
        }

        public ErrorCodes lockCurrency(UUID player, String currencyName, boolean value) {
            LinkedList<PlayerCurrency> playerCurrencies = this.getPlayersCurrency(player);
            Optional<PlayerCurrency> currencyOpt = playerCurrencies.stream().filter(c -> c.currency.getName().equalsIgnoreCase(currencyName)).findFirst();
            if (currencyOpt.isPresent()) {
                currencyOpt.get().isLocked = value;
                CurrencyPlayerData.save(this.server);
                return ErrorCodes.SUCCESS;
            }
            return ErrorCodes.NOT_FOUND;
        }

        public void newPlayer(Player player) {
            this.newPlayer(CurrencyHelper.getPlayerUUID(player));
        }

        public void newPlayer(UUID playerID) {
            if (CurrencyData.SERVER == null) {
                throw new IllegalStateException("CurrencyData.SERVER is null");
            }
            LinkedList currencies = new LinkedList();
            CurrencyData.SERVER.currencies.stream().map(Currency::copy).forEach(cur -> currencies.add(new PlayerCurrency((Currency)cur, cur.getDefaultValue())));
            this.playersCurrencyMap.put(playerID, currencies);
            CurrencyPlayerData.save(this.server);
        }
    }

    public static class Client {
        public LinkedList<PlayerCurrency> currencies = new LinkedList();

        public Optional<PlayerCurrency> getCurrency(String currencyName) {
            return this.currencies.stream().filter(c -> c.currency.getName().equalsIgnoreCase(currencyName)).findFirst();
        }

        public double getBalance(String currencyName) {
            return this.getCurrency(currencyName).map(s -> s.balance).orElse(0.0);
        }

        public boolean hasCurrency(String currencyName) {
            return this.getCurrency(currencyName).isPresent();
        }

        public ErrorCodeStruct<Boolean> isCurrencyLocked(String currencyName) {
            Optional<PlayerCurrency> currency = this.getCurrency(currencyName);
            return currency.map(playerCurrency -> new ErrorCodeStruct<Boolean>(playerCurrency.isLocked, ErrorCodes.SUCCESS)).orElseGet(() -> new ErrorCodeStruct<Boolean>(false, ErrorCodes.NOT_FOUND));
        }

        public LinkedList<PlayerCurrency> getAllLockedCurrency() {
            return this.currencies.stream().filter(c -> c.isLocked).collect(Collectors.toCollection(LinkedList::new));
        }

        public LinkedList<PlayerCurrency> getAllUnlockedCurrency() {
            return this.currencies.stream().filter(c -> !c.isLocked).collect(Collectors.toCollection(LinkedList::new));
        }

        public ErrorCodeStruct<Boolean> updateCurrency(PlayerCurrency currency) {
            return this.updateCurrency(currency.currency.getName(), currency.balance, currency.isLocked);
        }

        public ErrorCodeStruct<Boolean> updateCurrency(String currencyName, double value, boolean isLocked) {
            Optional<PlayerCurrency> currency = this.getCurrency(currencyName);
            if (currency.isPresent()) {
                currency.get().balance = value;
                currency.get().isLocked = isLocked;
                return new ErrorCodeStruct<Boolean>(true, ErrorCodes.SUCCESS);
            }
            return new ErrorCodeStruct<Boolean>(false, ErrorCodes.NOT_FOUND);
        }

        public ErrorCodes updateCurrencyForce(PlayerCurrency currency) {
            return this.updateCurrencyForce(currency.currency.getName(), currency.balance, currency.isLocked);
        }

        public ErrorCodes updateCurrencyForce(String currencyName, double value, boolean isLocked) {
            Optional<PlayerCurrency> currency = this.getCurrency(currencyName);
            if (currency.isPresent()) {
                currency.get().balance = value;
                currency.get().isLocked = isLocked;
                return ErrorCodes.SUCCESS;
            }
            Optional<Currency> cur = CurrencyData.CLIENT.currencies.stream().filter(s -> s.getName().equals(currencyName)).findFirst();
            if (cur.isPresent()) {
                PlayerCurrency ne = new PlayerCurrency(cur.get(), value);
                ne.isLocked = isLocked;
                this.currencies.add(ne);
                return ErrorCodes.SUCCESS;
            }
            return ErrorCodes.NOT_FOUND;
        }

        public void load(CompoundTag nbt) {
            this.currencies.clear();
            if (nbt.contains("currencies")) {
                ListTag currencyList = (ListTag)nbt.get("currencies");
                for (int i = 0; i < currencyList.size(); ++i) {
                    CompoundTag curTag = currencyList.getCompound(i);
                    this.currencies.add(PlayerCurrency.deserialize(curTag));
                }
            }
        }
    }

    public static class PlayerCurrency {
        public Currency currency;
        public double balance;
        public boolean isLocked = false;

        public PlayerCurrency(Currency currency, double balance) {
            this.currency = currency;
            this.balance = balance;
        }

        public PlayerCurrency setLocked(boolean locked) {
            this.isLocked = locked;
            return this;
        }

        public static PlayerCurrency deserialize(CompoundTag nbt) {
            return new PlayerCurrency(Currency.deserialize(nbt.getCompound("currency")), nbt.getDouble("balance")).setLocked(nbt.contains("isLocked"));
        }

        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.put("currency", (Tag)this.currency.serialize());
            nbt.putDouble("balance", this.balance);
            if (this.isLocked) {
                nbt.putBoolean("isLocked", true);
            }
            return nbt;
        }
    }
}

