/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy.economyData;

import java.nio.file.Path;
import java.util.LinkedList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.sixik.sdmeconomy.economy.Currency;
import net.sixik.sdmeconomy.economyData.CurrenciesIO;

public class CurrencyData {
    public static CurrencyData EMPTY = new CurrencyData(new LinkedList<Currency>());
    public static CurrencyData SERVER;
    public static CurrencyData CLIENT;
    public MinecraftServer server;
    public LinkedList<Currency> currencies;

    public CurrencyData(LinkedList<Currency> currencies) {
        this.currencies = currencies;
    }

    public void reloadCurrenciesFromFile(Path path) {
        this.currencies = CurrenciesIO.load(path);
    }

    public void reloadCurrenciesFromNetwork(CompoundTag nbt) {
        this.currencies = CurrenciesIO.loadFromNBT(nbt);
    }

    public CompoundTag serialize() {
        return CurrenciesIO.saveToNBT(this.currencies);
    }

    public static CurrencyData deserialize(CompoundTag nbt) {
        return new CurrencyData(CurrenciesIO.loadFromNBT(nbt));
    }

    public CurrencyData copy() {
        return new CurrencyData(new LinkedList<Currency>(this.currencies));
    }

    static {
        CLIENT = new CurrencyData(new LinkedList<Currency>());
    }
}

