/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy.economyData;

import com.google.common.collect.Maps;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.sixik.sdmeconomy.SDMEconomy;
import net.sixik.sdmeconomy.data.CustomPlayerData;
import net.sixik.sdmeconomy.economy.Currency;
import net.sixik.sdmeconomy.economyData.CurrencyPlayerData;
import org.apache.commons.io.FilenameUtils;

public class CurrenciesIO {
    public static Map<UUID, LinkedList<CurrencyPlayerData.PlayerCurrency>> loadPlayersData(Path path) {
        HashMap playerData = Maps.newHashMap();
        Path pathFolder = path.resolve("SDMEconomy/currencies/").resolve("players/");
        File fileFolder = pathFolder.toFile();
        if (!fileFolder.exists()) {
            fileFolder.mkdirs();
            return playerData;
        }
        for (File file : fileFolder.listFiles()) {
            try {
                UUID uuid = UUID.fromString(FilenameUtils.removeExtension((String)file.getName()));
                CompoundTag nbt = NbtIo.read((Path)file.toPath());
                if (nbt == null || !nbt.contains("currencies")) continue;
                ListTag currencyArrayNBT = (ListTag)nbt.get("currencies");
                for (Tag tag : currencyArrayNBT) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag listNBT = (CompoundTag)tag;
                    playerData.computeIfAbsent(uuid, k -> new LinkedList()).add(CurrencyPlayerData.PlayerCurrency.deserialize(listNBT));
                }
            }
            catch (Exception e) {
                SDMEconomy.printStackTrace("Error reading file " + String.valueOf(file), e);
            }
        }
        return playerData;
    }

    public static void savePlayersData(Path path, Map<UUID, LinkedList<CurrencyPlayerData.PlayerCurrency>> playerData) {
        Path pathFolder = path.resolve("SDMEconomy/currencies/").resolve("players/");
        File fileFolder = pathFolder.toFile();
        if (!fileFolder.exists()) {
            fileFolder.mkdirs();
        }
        for (Map.Entry<UUID, LinkedList<CurrencyPlayerData.PlayerCurrency>> entry : playerData.entrySet()) {
            UUID uuid = entry.getKey();
            try {
                File file = new File(fileFolder, uuid.toString() + ".data");
                CompoundTag nbt = new CompoundTag();
                ListTag currencyArrayNBT = new ListTag();
                for (CurrencyPlayerData.PlayerCurrency currency : entry.getValue()) {
                    currencyArrayNBT.add((Object)currency.serialize());
                }
                nbt.put("currencies", (Tag)currencyArrayNBT);
                NbtIo.write((CompoundTag)nbt, (Path)file.toPath());
            }
            catch (Exception e) {
                SDMEconomy.printStackTrace("Error writing file " + String.valueOf(uuid) + ".data", e);
            }
        }
    }

    public static LinkedList<Currency> load(Path path) {
        LinkedList<Currency> currencies = new LinkedList<Currency>();
        Path pathFolder = path.resolve("SDMEconomy/currencies/");
        File fileFolder = pathFolder.toFile();
        if (!fileFolder.exists()) {
            fileFolder.mkdirs();
            return currencies;
        }
        try {
            CompoundTag nbt = NbtIo.read((Path)pathFolder.resolve("currencies.data"));
            if (nbt != null && nbt.contains("currencies")) {
                ListTag currencyArrayNBT = (ListTag)nbt.get("currencies");
                for (Tag tag : currencyArrayNBT) {
                    if (!(tag instanceof CompoundTag)) continue;
                    CompoundTag listNBT = (CompoundTag)tag;
                    currencies.add(Currency.deserialize(listNBT));
                }
            }
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("Error reading file " + String.valueOf(pathFolder), e);
        }
        return currencies;
    }

    public static void save(Path path, List<Currency> currencies) {
        Path pathFolder = path.resolve("SDMEconomy/currencies/");
        File fileFolder = pathFolder.toFile();
        if (!fileFolder.exists()) {
            fileFolder.mkdirs();
        }
        CompoundTag nbt = new CompoundTag();
        ListTag currencyArrayNBT = new ListTag();
        for (Currency currency : currencies) {
            currencyArrayNBT.add((Object)currency.serialize());
        }
        nbt.put("currencies", (Tag)currencyArrayNBT);
        try {
            NbtIo.write((CompoundTag)nbt, (Path)pathFolder.resolve("currencies.data"));
        }
        catch (Exception e) {
            SDMEconomy.printStackTrace("Error writing file " + String.valueOf(pathFolder), e);
        }
    }

    public static LinkedList<Currency> loadFromNBT(CompoundTag nbt) {
        LinkedList<Currency> currencies = new LinkedList<Currency>();
        if (nbt.contains("currencies")) {
            ListTag currencyArrayNBT = nbt.getList("currencies", 10);
            for (Tag tag : currencyArrayNBT) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag listNBT = (CompoundTag)tag;
                currencies.add(Currency.deserialize(listNBT));
            }
        }
        return currencies;
    }

    public static CompoundTag saveToNBT(List<Currency> currencies) {
        CompoundTag nbt = new CompoundTag();
        ListTag currencyArrayNBT = new ListTag();
        for (Currency currency : currencies) {
            currencyArrayNBT.add((Object)currency.serialize());
        }
        nbt.put("currencies", (Tag)currencyArrayNBT);
        return nbt;
    }

    public static void saveCustomPlayerData(Path path, Map<UUID, CustomPlayerData.Data> playersData) {
        Path pathFolder = path.resolve("SDMEconomy/currencies/").resolve("players_custom_data/");
        File fileFolder = pathFolder.toFile();
        if (!fileFolder.exists()) {
            fileFolder.mkdirs();
        }
        for (Map.Entry<UUID, CustomPlayerData.Data> entry : playersData.entrySet()) {
            UUID uuid = entry.getKey();
            try {
                File file = new File(fileFolder, uuid.toString() + ".data");
                CompoundTag nbt = new CompoundTag();
                nbt.put("custom_data", (Tag)entry.getValue().nbt);
                NbtIo.write((CompoundTag)nbt, (Path)file.toPath());
            }
            catch (Exception e) {
                SDMEconomy.printStackTrace("Error writing file " + String.valueOf(uuid) + ".data", e);
            }
        }
    }

    public static Map<UUID, CustomPlayerData.Data> loadCustomPlayerData(Path path) {
        HashMap playersData = Maps.newHashMap();
        Path pathFolder = path.resolve("SDMEconomy/currencies/").resolve("players_custom_data/");
        File fileFolder = pathFolder.toFile();
        if (!fileFolder.exists()) {
            fileFolder.mkdirs();
            return playersData;
        }
        for (File file : fileFolder.listFiles()) {
            try {
                UUID uuid = UUID.fromString(FilenameUtils.removeExtension((String)file.getName()));
                CompoundTag nbt = NbtIo.read((Path)file.toPath());
                if (nbt == null || !nbt.contains("custom_data")) continue;
                CustomPlayerData.Data data = new CustomPlayerData.Data(nbt.getCompound("custom_data"));
                playersData.put(uuid, data);
            }
            catch (Exception e) {
                SDMEconomy.printStackTrace("Error reading file " + String.valueOf(file), e);
            }
        }
        return playersData;
    }

    public static class Constants {
        public static final String FOLDER = "SDMEconomy/currencies/";
        public static final String PLAYERS_FOLDER = "players/";
        public static final String PLAYER_CUSTOM_DATA = "players_custom_data/";
        public static final String FILE = "currencies.data";
        public static final String CURRENCY_ARRAY_KEY = "currencies";
        public static final String CUSTOM_DATA_KEY = "custom_data";
    }
}

