/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy.economy;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class CurrencySymbol {
    public String value;
    public Type type;

    public CurrencySymbol(String value) {
        this.value = value;
        ResourceLocation v = ResourceLocation.tryBySeparator((String)value, (char)':');
        if (v == null) {
            this.type = Type.CHAR;
            return;
        }
        this.type = Type.ICON;
    }

    public CurrencySymbol(String value, Type type) {
        this.value = value;
        this.type = type;
    }

    public CurrencySymbol copy() {
        return new CurrencySymbol(this.value, this.type);
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putString("value", this.value);
        tag.putInt("type", this.type.ordinal());
        return tag;
    }

    public static CurrencySymbol deserialize(CompoundTag tag) {
        return new CurrencySymbol(tag.getString("value"), Type.values()[tag.getInt("type")]);
    }

    public static enum Type {
        CHAR,
        ICON;

    }
}

