/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy.economy;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.sixik.sdmeconomy.api.CustomCurrencies;
import net.sixik.sdmeconomy.economy.CurrencySymbol;

public class Currency {
    protected final String name;
    protected final double defaultValue;
    public CurrencySymbol symbol;
    public boolean canDelete = true;

    public Currency(String name) {
        this(name, new CurrencySymbol("\u25ce"), 0.0);
    }

    public Currency(String name, CurrencySymbol symbol) {
        this(name, symbol, 0.0);
    }

    public Currency(String name, CurrencySymbol symbol, double defaultValue) {
        this.name = name;
        this.symbol = symbol;
        this.defaultValue = defaultValue;
    }

    public Currency canDelete(boolean value) {
        this.canDelete = value;
        return this;
    }

    public Currency copy() {
        return new Currency(this.name, this.symbol.copy(), this.defaultValue);
    }

    public String getName() {
        return this.name;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public Component getTranslation() {
        return Component.translatable((String)("sdm.currency." + this.name));
    }

    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.putString("name", this.name);
        tag.putDouble("defaultValue", this.defaultValue);
        tag.put("symbol", (Tag)this.symbol.serialize());
        return tag;
    }

    public static Currency deserialize(CompoundTag tag) {
        String name = tag.getString("name");
        double defaultValue = tag.getDouble("defaultValue");
        CurrencySymbol symbol = CurrencySymbol.deserialize(tag.getCompound("symbol"));
        return CustomCurrencies.CURRENCIES.getOrDefault(name, () -> new Currency(name, symbol, defaultValue)).get();
    }
}

