/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy.api;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.sixik.sdmeconomy.network.ASK.ASKHandler;

public abstract class AbstractASKRequest {
    public AbstractASKRequest(Void empty) {
    }

    public abstract void onServerTakeRequest(CompoundTag var1, NetworkManager.PacketContext var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void onClientTakeRequest(CompoundTag var1, NetworkManager.PacketContext var2);

    public abstract String getId();

    public void sendTo(ServerPlayer player, CompoundTag data) {
        ASKHandler.sendToClient(player, new ASKHandler.Data(this.getId(), data));
    }

    public void sendTo(ServerPlayer player, CompoundTag ... data) {
        for (CompoundTag datum : data) {
            ASKHandler.sendToClient(player, new ASKHandler.Data(this.getId(), datum));
        }
    }

    public void sendToAll(MinecraftServer server, CompoundTag data) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            this.sendTo(player, data);
        }
    }

    public void sendToAll(MinecraftServer server, CompoundTag ... data) {
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            this.sendTo(player, data);
        }
    }

    public void sendToServer(CompoundTag data) {
        ASKHandler.sendToServer(new ASKHandler.Data(this.getId(), data));
    }

    public void executePerSend(Supplier<CompoundTag> supplier) {
        this.sendToServer(supplier.get());
    }

    public void executePerSend(Supplier<CompoundTag[]> supplier, ServerPlayer player) {
        this.sendTo(player, supplier.get());
    }

    public void executePerSend(Supplier<CompoundTag[]> supplier, MinecraftServer server) {
        this.sendToAll(server, supplier.get());
    }
}

