/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmeconomy;

import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.platform.Platform;
import java.util.LinkedList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.sixik.sdmeconomy.api.EconomyAPI;
import net.sixik.sdmeconomy.data.CustomPlayerData;
import net.sixik.sdmeconomy.economy.Currency;
import net.sixik.sdmeconomy.economyData.CurrencyData;
import net.sixik.sdmeconomy.economyData.CurrencyPlayerData;
import net.sixik.sdmeconomy.integrations.impactor.ImpactorCurrency;
import net.sixik.sdmeconomy.integrations.impactor.ImpactorHelper;
import net.sixik.sdmeconomy.network.ASK.ASKHandler;
import net.sixik.sdmeconomy.utils.CurrencyHelper;

public class SDMEconomyEvents {
    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(EconomyAPI::syncPlayer);
        TickEvent.SERVER_POST.register(server -> {
            if (server.getTickCount() % 12000 == 0) {
                EconomyAPI.saveAll(server);
            }
        });
        LifecycleEvent.SERVER_STARTED.register(server -> {
            new ASKHandler((MinecraftServer)server);
            CurrencyData.SERVER = new CurrencyData(new LinkedList<Currency>());
            CurrencyData.SERVER.server = server;
            if (ImpactorCurrency.isLoaded()) {
                ImpactorHelper.registerImpactorCurrencies();
            }
            CurrencyData.SERVER.reloadCurrenciesFromFile(Platform.getConfigFolder());
            CurrencyPlayerData.load(server);
            CurrencyHelper.checkNewCurrency();
            CustomPlayerData.Server.load(server.getWorldPath(LevelResource.ROOT));
            EconomyAPI.saveAll(server);
        });
        LifecycleEvent.SERVER_STOPPED.register(EconomyAPI::saveAll);
    }
}

