/*
 * Decompiled with CFR 0.152.
 */
package com.leobeliik.extremesoundmuffler.gui;

import com.leobeliik.extremesoundmuffler.CommonConfig;
import com.leobeliik.extremesoundmuffler.Constants;
import com.leobeliik.extremesoundmuffler.SoundMufflerCommon;
import com.leobeliik.extremesoundmuffler.gui.buttons.MuffledSlider;
import com.leobeliik.extremesoundmuffler.interfaces.IColorsGui;
import com.leobeliik.extremesoundmuffler.interfaces.ISoundLists;
import com.leobeliik.extremesoundmuffler.utils.Anchor;
import com.leobeliik.extremesoundmuffler.utils.DataManager;
import com.leobeliik.extremesoundmuffler.utils.Tips;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MufflerScreen
extends Screen
implements ISoundLists,
IColorsGui {
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static boolean isMuffling = false;
    private static Component toggleSoundsListMessage;
    private static Component screenTitle;
    private static Component tip;
    private final int xSize = 256;
    private final int ySize = 202;
    private final int maxAnchorRange = CommonConfig.get().maxAnchorRange().get();
    private final boolean isAnchorsDisabled = CommonConfig.get().disableAnchors().get();
    private int minYButton;
    private int maxYButton;
    private int index;
    private Button btnTMS;
    private Button btnDelete;
    private Button btnCSL;
    private Button btnSetAnchor;
    private Button btnEditAnchor;
    private Button btnNextSounds;
    private Button btnPrevSounds;
    private Button btnAccept;
    private Button btnCancel;
    private Button btnAnchor;
    private EditBox searchBar;
    private EditBox editAnchorTitleBar;
    private EditBox editRadBar;
    private MuffledSlider firstSoundButton;
    private MuffledSlider lastSoundButton;
    private Anchor anchor;

    private MufflerScreen(Component title, Anchor anchor) {
        super(title);
        screenTitle = title;
        this.anchor = anchor;
        minecraft.setScreen((Screen)this);
    }

    protected void init() {
        super.init();
        this.minYButton = this.getY() + 46;
        this.maxYButton = this.getY() + 164;
        this.addButtons();
        this.addSideButtons();
        this.addAnchorButtons();
        this.addSoundListButtons();
    }

    public void render(@NotNull GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        SoundMufflerCommon.renderGui();
        stack.blit(SoundMufflerCommon.getTextureRL(), this.getX(), this.getY(), 0, 0, 256, 202);
        this.renderSideScreen(stack);
        super.render(stack, mouseX, mouseY, partialTicks);
        stack.drawCenteredString(this.font, screenTitle, this.getX() + 128, this.getY() + 8, 0xFFFFFF);
        this.renderTips(stack);
        this.renderButtons(stack, mouseX, mouseY);
    }

    public void renderBackground(@NotNull GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.editRadBar.setFilter(s -> s.matches("[0-9]*(?:[0-9]*)?"));
        if (keyCode == 257 || keyCode == 335) {
            this.searchBar.setFocused(false);
            this.editAnchorTitleBar.setFocused(false);
            this.editRadBar.setFocused(false);
            return true;
        }
        if (!(this.searchBar.isFocused() || this.editAnchorTitleBar.isFocused() || this.editRadBar.isFocused() || !MufflerScreen.minecraft.options.keyInventory.matches(keyCode, scanCode) && !Constants.soundMufflerKey.matches(keyCode, scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.isFocused()) {
            this.updateButtons();
        }
        if (!this.editRadBar.getValue().isEmpty()) {
            int radius = Integer.parseInt(this.editRadBar.getValue());
            this.editRadBar.setTextColor(radius > this.maxAnchorRange || radius < 1 ? -2292989 : 0xFFFFFF);
        } else {
            this.editRadBar.setTextColor(0xFFFFFF);
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double directionH, double directionV) {
        double dir;
        double d = dir = directionH == 0.0 ? directionV : directionH;
        if (this.firstSoundButton == null) {
            return false;
        }
        if (dir > 0.0 && this.firstSoundButton.getY() == this.minYButton || dir < 0.0 && this.lastSoundButton.getY() <= this.maxYButton) {
            return false;
        }
        this.children().stream().filter(b -> b instanceof MuffledSlider).map(b -> (MuffledSlider)b).forEach(b -> {
            b.setY((int)((double)b.getY() + (double)(b.getHeight() * 9) * Mth.clamp((double)dir, (double)-1.0, (double)1.0)));
            b.isVisible(b.getY() >= this.minYButton && b.getY() <= this.maxYButton);
        });
        return super.mouseScrolled(mouseX, mouseY, directionH, directionV);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1) {
            if (this.searchBar.isFocused()) {
                this.searchBar.setValue("");
                this.updateButtons();
                return true;
            }
            if (this.editAnchorTitleBar.isFocused()) {
                this.editAnchorTitleBar.setValue("");
                return true;
            }
            if (this.editRadBar.isHoveredOrFocused()) {
                this.editRadBar.setValue("");
                return true;
            }
        } else {
            this.searchBar.setFocused(this.searchBar.isMouseOver(mouseX, mouseY));
            this.editAnchorTitleBar.setFocused(this.editAnchorTitleBar.isMouseOver(mouseX, mouseY));
            this.editRadBar.setFocused(this.editRadBar.isMouseOver(mouseX, mouseY));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void onClose() {
        DataManager.saveData();
        super.onClose();
    }

    private void open(Component title, Anchor anchor) {
        new MufflerScreen(title, anchor);
    }

    public static void open() {
        new MufflerScreen((Component)Component.translatable((String)"main_screen.main_title"), null);
    }

    private void addButtons() {
        this.btnCSL = Button.builder((Component)Component.translatable((String)"main_screen.btn.csl.recent"), b -> {
            boolean isAnchorMuffling = this.anchor != null && !this.anchor.getMuffledSounds().isEmpty();
            Component component = this.btnCSL.getMessage();
            toggleSoundsListMessage = Component.translatable((String)"main_screen.btn.csl.recent").equals((Object)component) ? Component.translatable((String)"main_screen.btn.csl.all") : (Component.translatable((String)"main_screen.btn.csl.all").equals((Object)component) ? Component.translatable((String)"main_screen.btn.csl.muffled") : Component.translatable((String)"main_screen.btn.csl.recent"));
            b.setMessage(toggleSoundsListMessage);
            this.updateButtons();
        }).bounds(this.getX() + 13, this.getY() + 181, 52, 13).build();
        this.addWidget((GuiEventListener)this.btnCSL);
        this.searchBar = new EditBox(this.font, this.getX() + 74, this.getY() + 183, 119, 13, (Component)Component.empty());
        ((EditBox)this.addRenderableWidget((GuiEventListener)this.searchBar)).setBordered(false);
        this.btnTMS = Button.builder((Component)Component.translatable((String)"main_screen.btn.tms.stop"), b -> MufflerScreen.setMuffling(!isMuffling)).bounds(this.getX() + 229, this.getY() + 180, 17, 17).build();
        this.addWidget((GuiEventListener)this.btnTMS);
        this.btnDelete = Button.builder((Component)Component.translatable((String)"main_screen.btn.delete.sounds"), b -> {
            if (MufflerScreen.hasShiftDown()) {
                recentSoundsList.clear();
            } else if (this.anchor == null) {
                muffledSounds.clear();
            } else {
                this.anchor.deleteAnchor();
            }
            this.updateButtons();
        }).bounds(this.getX() + 205, this.getY() + 180, 17, 17).build();
        this.addWidget((GuiEventListener)this.btnDelete);
        this.btnPrevSounds = Button.builder((Component)Component.empty(), b -> this.mouseScrolled(0.0, 0.0, 1.0, 0.0)).bounds(this.getX() + 10, this.getY() + 22, 13, 20).build();
        this.addWidget((GuiEventListener)this.btnPrevSounds);
        this.btnNextSounds = Button.builder((Component)Component.empty(), b -> this.mouseScrolled(0.0, 0.0, -1.0, 0.0)).bounds(this.getX() + 233, this.getY() + 22, 13, 20).build();
        this.addWidget((GuiEventListener)this.btnNextSounds);
    }

    private void addSideButtons() {
        this.btnSetAnchor = Button.builder((Component)Component.empty(), b -> this.anchor.setAnchor(this.maxAnchorRange)).bounds(this.getX() + 261, this.getY() + 62, 11, 11).build();
        ((Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.empty(), b -> this.anchor.setAnchor(this.maxAnchorRange)).bounds(this.getX() + 261, this.getY() + 62, 11, 11).build())).active = false;
        this.btnEditAnchor = Button.builder((Component)Component.empty(), b -> this.editTitle()).bounds(this.getX() + 275, this.getY() + 62, 11, 11).build();
        ((Button)this.addWidget((GuiEventListener)Button.builder((Component)Component.empty(), b -> this.editTitle()).bounds(this.getX() + 275, this.getY() + 62, 11, 11).build())).active = false;
        this.editAnchorTitleBar = new EditBox(this.font, this.getX() + 302, this.btnEditAnchor.getY() + 20, 84, 11, (Component)Component.empty());
        ((EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.getX() + 302, this.btnEditAnchor.getY() + 20, 84, 11, (Component)Component.empty()))).visible = false;
        this.editRadBar = new EditBox(this.font, this.getX() + 302, this.editAnchorTitleBar.getY() + 15, 30, 11, (Component)Component.empty());
        ((EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.getX() + 302, this.editAnchorTitleBar.getY() + 15, 30, 11, (Component)Component.empty()))).visible = false;
        this.btnAccept = Button.builder((Component)Component.translatable((String)"main_screen.btn.accept"), b -> {
            if (!this.editAnchorTitleBar.getValue().isEmpty() && !this.editRadBar.getValue().isEmpty() && this.anchor != null) {
                this.anchor.editAnchor(this.editAnchorTitleBar.getValue(), Mth.clamp((int)Integer.parseInt(this.editRadBar.getValue()), (int)1, (int)this.maxAnchorRange));
                screenTitle = Component.nullToEmpty((String)this.editAnchorTitleBar.getValue());
                this.editTitle();
            }
        }).bounds(this.getX() + 259, this.editRadBar.getY() + 15, 40, 20).build();
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"main_screen.btn.accept"), b -> {
            if (!this.editAnchorTitleBar.getValue().isEmpty() && !this.editRadBar.getValue().isEmpty() && this.anchor != null) {
                this.anchor.editAnchor(this.editAnchorTitleBar.getValue(), Mth.clamp((int)Integer.parseInt(this.editRadBar.getValue()), (int)1, (int)this.maxAnchorRange));
                screenTitle = Component.nullToEmpty((String)this.editAnchorTitleBar.getValue());
                this.editTitle();
            }
        }).bounds(this.getX() + 259, this.editRadBar.getY() + 15, 40, 20).build())).visible = false;
        this.btnCancel = Button.builder((Component)Component.translatable((String)"main_screen.btn.cancel"), b -> this.editTitle()).bounds(this.getX() + 300, this.editRadBar.getY() + 15, 40, 20).build();
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"main_screen.btn.cancel"), b -> this.editTitle()).bounds(this.getX() + 300, this.editRadBar.getY() + 15, 40, 20).build())).visible = false;
    }

    private void addAnchorButtons() {
        int buttonW = this.getX() + 30;
        for (int i = 0; i <= 9; ++i) {
            if (this.isAnchorsDisabled) {
                String[] disabledMsg = new String[]{"-", "D", "i", "s", "a", "b", "l", "e", "d", "-"};
                this.btnAnchor = Button.builder((Component)Component.nullToEmpty((String)disabledMsg[i]), b -> {}).bounds(buttonW, this.getY() + 24, 16, 16).build();
                this.btnAnchor.active = false;
            } else {
                int finalI = i;
                this.btnAnchor = Button.builder((Component)Component.nullToEmpty((String)String.valueOf(i)), b -> {
                    this.anchor = (Anchor)anchorList.get(finalI);
                    this.hideSideButtons();
                    if (screenTitle.getString().equals(this.anchor.getName()) || this.anchor == null) {
                        this.anchor = null;
                        screenTitle = Component.translatable((String)"main_screen.main_title");
                    } else {
                        screenTitle = Component.nullToEmpty((String)this.anchor.getName());
                        this.btnSetAnchor.active = true;
                        this.updateAnchor(this.anchor);
                    }
                    this.updateButtons();
                }).bounds(buttonW, this.getY() + 24, 16, 16).build();
            }
            ((Button)this.addRenderableWidget((GuiEventListener)this.btnAnchor)).setAlpha(0.0f);
            buttonW += 20;
        }
    }

    private void updateAnchor(Anchor anchor) {
        double radius = anchor.getRadius();
        if (radius > (double)this.maxAnchorRange) {
            anchor.setRadius((int)Math.min(radius, (double)this.maxAnchorRange));
        }
        this.anchor = anchor;
    }

    private void addSoundListButtons() {
        int bx;
        int by;
        block15: {
            block14: {
                by = this.minYButton;
                bx = CommonConfig.get().leftButtons().get() != false ? this.getX() + 38 : this.getX() + 11;
                this.firstSoundButton = null;
                soundsList.clear();
                Component component = this.btnCSL.getMessage();
                if (Component.translatable((String)"main_screen.btn.csl.recent").equals((Object)component)) {
                    soundsList.addAll(recentSoundsList);
                    Collections.reverse(soundsList);
                } else if (Component.translatable((String)"main_screen.btn.csl.all").equals((Object)component)) {
                    BuiltInRegistries.SOUND_EVENT.forEach(k -> soundsList.add(k.getLocation()));
                    Collections.sort(soundsList);
                } else {
                    soundsList.addAll(this.anchor == null ? muffledSounds.keySet() : this.anchor.getMuffledSounds().keySet());
                }
                if (CommonConfig.get().lawfulAllList().get().booleanValue() && this.btnCSL.getMessage().equals((Object)Component.translatable((String)"main_screen.btn.csl.all"))) break block14;
                if (!this.btnCSL.getMessage().equals((Object)Component.translatable((String)"main_screen.btn.csl.recent"))) break block15;
            }
            forbiddenSounds.stream().map(fs -> sl -> sl != null && sl.toString().contains((CharSequence)fs)).forEach(soundsList::removeIf);
        }
        if (soundsList.isEmpty()) {
            return;
        }
        for (ResourceLocation sound : soundsList) {
            if (!sound.toString().contains(this.searchBar.getValue())) continue;
            double volume = this.anchor == null ? (muffledSounds.get(sound) == null ? 1.0 : (Double)muffledSounds.get(sound)) : (this.anchor.getMuffledSounds().get(sound) == null ? 1.0 : (Double)this.anchor.getMuffledSounds().get(sound));
            int bg = this.children().size() % 2 == 0 ? darkBG : brightBG;
            MuffledSlider btnSound = new MuffledSlider(bx, by, bg, sound, volume, this);
            if (this.anchor != null) {
                this.setFGColor(btnSound, this.anchor.getMuffledSounds().containsKey(sound) ? "aqua" : "white");
            } else if (!muffledSounds.isEmpty()) {
                this.setFGColor(btnSound, muffledSounds.containsKey(sound) ? "aqua" : "white");
            } else {
                this.setFGColor(btnSound, "white");
            }
            this.addRenderableWidget((GuiEventListener)btnSound);
            by += btnSound.getHeight();
            btnSound.isVisible(btnSound.getY() < this.maxYButton);
            if (this.firstSoundButton == null) {
                this.firstSoundButton = btnSound;
            }
            this.lastSoundButton = btnSound;
        }
    }

    private void updateButtons() {
        Iterator iterator = this.children().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof MuffledSlider)) continue;
            MuffledSlider button = (MuffledSlider)e;
            button.isVisible(false);
            iterator.remove();
        }
        this.addSoundListButtons();
    }

    private void renderButtons(GuiGraphics stack, int mouseX, int mouseY) {
        boolean notMuffling;
        MutableComponent message;
        if (isMuffling) {
            stack.blit(SoundMufflerCommon.getTextureRL(), this.btnTMS.getX() + 1, this.btnTMS.getY(), 54.0f, 202.0f, 15, 15, 256, 256);
        }
        MutableComponent mutableComponent = message = isMuffling ? Component.translatable((String)"main_screen.btn.tms.stop") : Component.translatable((String)"main_screen.btn.tms.start");
        if (this.btnTMS.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnTMS);
        }
        MutableComponent mutableComponent2 = message = this.anchor == null ? Component.translatable((String)"main_screen.btn.delete.sounds") : Component.translatable((String)"main_screen.btn.delete.anchor");
        if (MufflerScreen.hasShiftDown()) {
            stack.blit(SoundMufflerCommon.getTextureRL(), this.btnDelete.getX() + 2, this.btnDelete.getY() + 1, 54.0f, 217.0f, 13, 13, 256, 256);
            message = Component.translatable((String)"main_screen.btn.delete.list");
        }
        if (this.btnDelete.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnDelete);
        }
        MutableComponent searchHint = Component.translatable((String)"gui.recipebook.search_hint").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
        if (!this.searchBar.isFocused() && this.searchBar.getValue().isEmpty()) {
            stack.drawString(this.font, (Component)searchHint, this.searchBar.getX() + 1, this.searchBar.getY() + 1, -1);
        }
        boolean bl = notMuffling = this.anchor == null ? muffledSounds.isEmpty() : this.anchor.getMuffledSounds().isEmpty();
        if (notMuffling && this.btnCSL.getMessage().equals((Object)Component.translatable((String)"main_screen.btn.csl.muffled"))) {
            MutableComponent text = Component.translatable((String)"main_screen.empty").copy().withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
            stack.drawCenteredString(this.font, (Component)text, this.getX() + 128, this.getY() + 101, 0xFFFFFF);
        }
        float centerX = (float)this.btnCSL.getX() + (float)this.btnCSL.getWidth() / 2.0f - (float)this.font.width(this.btnCSL.getMessage().getString()) / 2.0f;
        stack.drawString(this.font, this.btnCSL.getMessage().getString(), (int)centerX, this.btnCSL.getY() + 3, 0, false);
        message = Component.translatable((String)"main_screen.btn.csl.tooltip", (Object[])new Object[]{this.btnCSL.getMessage().getString()});
        if (this.btnCSL.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnCSL);
        }
        message = Component.translatable((String)"main_screen.btn.next_sounds");
        if (this.btnNextSounds.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnNextSounds);
        }
        message = Component.translatable((String)"main_screen.btn.previous_sounds");
        if (this.btnPrevSounds.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)message, (AbstractWidget)this.btnPrevSounds);
        }
        if (mouseX > this.getX() + 30 && mouseX < this.btnAnchor.getX() + this.btnAnchor.getWidth() && mouseY > this.btnAnchor.getY() && mouseY < this.btnAnchor.getY() + this.btnAnchor.getHeight() && CommonConfig.get().disableAnchors().get().booleanValue()) {
            stack.renderTooltip(this.font, (Component)Component.translatable((String)"main_screen.btn.anchors.disabled"), this.getX() + 60, this.getY() + 40);
        }
        for (GuiEventListener widget : this.children()) {
            if (!(widget instanceof AbstractWidget)) continue;
            AbstractWidget btn = (AbstractWidget)widget;
            if (btn instanceof MuffledSlider) {
                if (this.anchor == null || this.anchor.getAnchorPos() != null || !((MuffledSlider)widget).getBtnToggleSound().isMouseOver((double)mouseX, (double)mouseY)) continue;
                this.renderButtonTooltip(stack, (Component)Component.translatable((String)"main_screen.btn.anchors.set_message"), (AbstractWidget)((MuffledSlider)widget).getBtnToggleSound());
                continue;
            }
            if (!btn.getMessage().getString().matches("[0-9]") || anchorList.isEmpty()) continue;
            String color = ((Anchor)anchorList.get(Integer.parseInt(btn.getMessage().getString()))).getAnchorPos() != null ? "green" : "white";
            this.setFGColor(btn, color);
            if (this.anchor == null || !btn.getMessage().getString().equals(String.valueOf(this.anchor.getAnchorId()))) continue;
            stack.blit(SoundMufflerCommon.getTextureRL(), btn.getX() - 5, btn.getY() - 2, 71.0f, 202.0f, 27, 22, 256, 256);
        }
        if (this.editRadBar.isHoveredOrFocused()) {
            this.renderButtonTooltip(stack, (Component)Component.translatable((String)"main_screen.btn.anchors.set_range", (Object[])new Object[]{this.maxAnchorRange}), (AbstractWidget)this.editRadBar);
        }
        if (this.editAnchorTitleBar.isHoveredOrFocused()) {
            this.renderButtonTooltip(stack, (Component)Component.translatable((String)"main_screen.btn.anchors.set_title"), (AbstractWidget)this.editAnchorTitleBar);
        }
        if (this.btnSetAnchor.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)Component.translatable((String)"main_screen.btn.anchors.set"), (AbstractWidget)this.btnSetAnchor);
        }
        if (this.btnEditAnchor.isMouseOver((double)mouseX, (double)mouseY)) {
            this.renderButtonTooltip(stack, (Component)Component.translatable((String)"main_screen.btn.anchors.edit"), (AbstractWidget)this.btnEditAnchor);
        }
    }

    private void renderSideScreen(GuiGraphics stack) {
        String radius;
        if (this.anchor == null) {
            return;
        }
        String dimensionName = "";
        int x = this.btnSetAnchor.getX();
        int y = this.btnSetAnchor.getY();
        int stringW = this.font.width((FormattedText)Component.translatable((String)"main_screen.side_screen.dimension"));
        String string = radius = this.anchor.getRadius() == 0 ? "" : String.valueOf(this.anchor.getRadius());
        if (this.anchor.getDimension() != null) {
            stringW += this.font.width(this.anchor.getDimension().getPath());
            dimensionName = this.anchor.getDimension().getPath();
        }
        stack.fill(x - 5, y - 57, x + stringW + 7, y + 17, whiteBG);
        stack.fill(x - 5, y - 56, x + stringW + 6, y + 16, darkBG);
        stack.drawString(this.font, (Component)Component.translatable((String)"main_screen.side_screen.x", (Object[])new Object[]{this.anchor.getX()}), x + 1, y - 50, 0xFFFFFF);
        stack.drawString(this.font, (Component)Component.translatable((String)"main_screen.side_screen.y", (Object[])new Object[]{this.anchor.getY()}), x + 1, y - 40, 0xFFFFFF);
        stack.drawString(this.font, (Component)Component.translatable((String)"main_screen.side_screen.z", (Object[])new Object[]{this.anchor.getZ()}), x + 1, y - 30, 0xFFFFFF);
        stack.drawString(this.font, (Component)Component.translatable((String)"main_screen.side_screen.radius", (Object[])new Object[]{radius}), x + 1, y - 20, 0xFFFFFF);
        stack.drawString(this.font, (Component)Component.translatable((String)"main_screen.side_screen.dimension", (Object[])new Object[]{dimensionName}), x + 1, y - 10, 0xFFFFFF);
        SoundMufflerCommon.renderGui();
        stack.blit(SoundMufflerCommon.getTextureRL(), x, y, 0.0f, 69.45f, 11, 11, 88, 88);
        if (this.anchor.getAnchorPos() != null) {
            this.btnEditAnchor.active = true;
            stack.blit(SoundMufflerCommon.getTextureRL(), this.btnEditAnchor.getX(), this.btnEditAnchor.getY(), 32.0f, 213.0f, 11, 11, 256, 256);
        } else {
            this.btnEditAnchor.active = false;
        }
        x = this.btnSetAnchor.getX();
        y = this.editAnchorTitleBar.getY();
        if (this.editRadBar.visible) {
            stack.fill(x + stringW + 7, y - 5, this.editAnchorTitleBar.getX() + this.editAnchorTitleBar.getWidth() + 4, this.btnAccept.getY() + 23, whiteBG);
            stack.fill(x - 5, this.btnAccept.getY() + 23, this.editAnchorTitleBar.getX() + this.editAnchorTitleBar.getWidth() + 4, this.btnAccept.getY() + 24, whiteBG);
            stack.fill(x - 6, y - 4, this.editAnchorTitleBar.getX() + this.editAnchorTitleBar.getWidth() + 3, this.btnAccept.getY() + 23, darkBG);
            stack.drawString(this.font, (Component)Component.translatable((String)"main_screen.side_screen.title"), x - 2, y + 1, 0xFFFFFF);
            stack.drawString(this.font, (Component)Component.translatable((String)"main_screen.side_screen.radius_edit"), x - 2, this.editRadBar.getY() + 1, 0xFFFFFF);
        }
    }

    private void renderButtonTooltip(GuiGraphics stack, Component message, AbstractWidget button) {
        int CSLShift = button.equals(this.btnCSL) ? 25 : 0;
        int centeredMessageX = button.getX() - (this.font.width((FormattedText)message) - CSLShift) / 2;
        int centeredMessageY = button.equals(this.btnPrevSounds) || button.equals(this.btnNextSounds) ? button.getY() - 1 : button.getY() + button.getHeight() + 16;
        stack.renderTooltip(this.font, message, centeredMessageX, centeredMessageY);
    }

    private void renderTips(GuiGraphics stack) {
        if (CommonConfig.get().showTip().get().booleanValue()) {
            if (this.index % 500 == 0) {
                tip = Component.translatable((String)Tips.randomTip());
                this.index = 0;
            }
            Objects.requireNonNull(this.font);
            int h = 9 * (this.font.width((FormattedText)Component.translatable((String)"main_screen.tip", (Object[])new Object[]{tip})) / 240 + 1) + 215;
            stack.fill(this.getX() - 2, this.getY() + 208, this.getX() + 257, this.getY() + h + 2, darkBG);
            stack.fill(this.getX() - 1, this.getY() + 209, this.getX() + 256, this.getY() + h + 1, goldBG);
            stack.fill(this.getX(), this.getY() + 210, this.getX() + 255, this.getY() + h, darkBG);
            stack.drawWordWrap(this.font, (FormattedText)Component.translatable((String)"main_screen.tip", (Object[])new Object[]{tip}), this.getX() + 5, this.getY() + 213, 245, 0xFFFFFF);
            ++this.index;
        }
    }

    private void hideSideButtons() {
        this.btnSetAnchor.active = false;
        this.btnEditAnchor.active = false;
        this.editAnchorTitleBar.visible = false;
        this.editRadBar.visible = false;
        this.btnAccept.visible = false;
        this.btnCancel.visible = false;
    }

    private void editTitle() {
        this.editAnchorTitleBar.setValue(this.anchor.getName());
        this.editAnchorTitleBar.visible = !this.editAnchorTitleBar.visible;
        this.editRadBar.setValue(String.valueOf(this.anchor.getRadius()));
        this.editRadBar.visible = !this.editRadBar.visible;
        this.btnAccept.visible = !this.btnAccept.visible;
        this.btnCancel.visible = !this.btnCancel.visible;
        this.editRadBar.setTextColor(0xFFFFFF);
    }

    public boolean removeSoundMuffled(ResourceLocation sound) {
        if (this.anchor != null) {
            if (this.anchor.getAnchorPos() != null) {
                this.anchor.removeSound(sound);
                return true;
            }
        } else {
            muffledSounds.remove(sound);
            return true;
        }
        return false;
    }

    public boolean addSoundMuffled(ResourceLocation sound, double volume) {
        if (this.anchor != null) {
            if (this.anchor.getAnchorPos() != null) {
                this.anchor.addSound(sound, volume);
                return true;
            }
        } else {
            muffledSounds.put(sound, volume);
            return true;
        }
        return false;
    }

    public void replaceVolume(ResourceLocation sound, double volume) {
        if (this.anchor != null) {
            this.anchor.replaceSound(sound, volume);
        } else {
            muffledSounds.replace(sound, volume);
        }
    }

    public static boolean isMuffling() {
        return isMuffling;
    }

    public static void setMuffling(boolean muffling) {
        isMuffling = muffling;
    }

    private int getX() {
        return (this.width - 256) / 2;
    }

    private int getY() {
        return (this.height - 202) / 2;
    }

    public Component getBtnCSLTitle() {
        return this.btnCSL.getMessage();
    }
}

