/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item;

import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.buuz135.functionalstorage.item.component.SizeProvider;
import com.google.common.base.Suppliers;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class FSAttachments {
    public static final DeferredRegister<DataComponentType<?>> DR = DeferredRegister.create((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"functionalstorage");
    public static final Supplier<DataComponentType<ConfigurationToolItem.ConfigurationAction>> CONFIGURATION_ACTION = FSAttachments.register("configuration_action", () -> ConfigurationToolItem.ConfigurationAction.LOCKING, builder -> builder.persistent(ConfigurationToolItem.ConfigurationAction.CODEC));
    public static final Supplier<DataComponentType<LinkingToolItem.ActionMode>> ACTION_MODE = FSAttachments.register("action_mode", () -> LinkingToolItem.ActionMode.ADD, builder -> builder.persistent(LinkingToolItem.ActionMode.CODEC));
    public static final Supplier<DataComponentType<LinkingToolItem.LinkingMode>> LINKING_MODE = FSAttachments.register("linking_mode", () -> LinkingToolItem.LinkingMode.SINGLE, builder -> builder.persistent(LinkingToolItem.LinkingMode.CODEC));
    public static final Supplier<DataComponentType<BlockPos>> FIRST_POSITION = FSAttachments.register("first_pos", () -> BlockPos.ZERO, builder -> builder.persistent(BlockPos.CODEC));
    public static final ComponentSupplier<BlockPos> CONTROLLER = FSAttachments.register("controller_position", () -> BlockPos.ZERO, builder -> builder.persistent(BlockPos.CODEC));
    public static final Supplier<DataComponentType<String>> ENDER_FREQUENCY = FSAttachments.register("ender_frequency", () -> "", op -> op.persistent((Codec)Codec.STRING));
    public static final Supplier<DataComponentType<Unit>> ENDER_SAFETY = FSAttachments.register("ender_safety", () -> Unit.INSTANCE, op -> op.persistent(Codec.unit((Object)Unit.INSTANCE)));
    public static final Supplier<DataComponentType<Direction>> DIRECTION = FSAttachments.register("direction", () -> Direction.NORTH, op -> op.persistent((Codec)Direction.CODEC));
    public static final Supplier<DataComponentType<Integer>> SLOT = FSAttachments.register("slot", () -> 0, op -> op.persistent(Codec.intRange((int)0, (int)3)));
    public static final Supplier<DataComponentType<Boolean>> LOCKED = FSAttachments.register("locked", () -> false, op -> op.persistent((Codec)Codec.BOOL));
    public static final Supplier<DataComponentType<CompoundTag>> TILE = FSAttachments.register("tile", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<CompoundTag>> STYLE = FSAttachments.register("style", CompoundTag::new, op -> op.persistent(CompoundTag.CODEC));
    public static final Supplier<DataComponentType<SizeProvider>> ITEM_STORAGE_MODIFIER = FSAttachments.register("item_storage_modifier", SizeProvider.CODEC);
    public static final Supplier<DataComponentType<SizeProvider>> FLUID_STORAGE_MODIFIER = FSAttachments.register("fluid_storage_modifier", SizeProvider.CODEC);
    public static final Supplier<DataComponentType<SizeProvider>> CONTROLLER_RANGE_MODIFIER = FSAttachments.register("controller_range_modifier", SizeProvider.CODEC);
    public static final Supplier<DataComponentType<FunctionalUpgradeBehavior>> FUNCTIONAL_BEHAVIOR = FSAttachments.register("functional_upgrade_behavior", FunctionalUpgradeBehavior.CODEC);
    public static final Supplier<DataComponentType<HolderSet<Item>>> INCOMPATIBLE_UPGRADES = FSAttachments.register("incompatible_upgrades", RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM));

    private static <T> Supplier<DataComponentType<T>> register(String name, Codec<T> codec) {
        return DR.register(name, () -> DataComponentType.builder().persistent(codec).build());
    }

    private static <T> ComponentSupplier<T> register(String name, Supplier<T> defaultVal, UnaryOperator<DataComponentType.Builder<T>> op) {
        DeferredHolder registered = DR.register(name, () -> ((DataComponentType.Builder)op.apply(DataComponentType.builder())).build());
        return new ComponentSupplier<T>(registered, defaultVal);
    }

    public static class ComponentSupplier<T>
    implements Supplier<DataComponentType<T>> {
        private final Supplier<DataComponentType<T>> type;
        private final Supplier<T> defaultSupplier;

        public ComponentSupplier(Supplier<DataComponentType<T>> type, Supplier<T> defaultSupplier) {
            this.type = type;
            this.defaultSupplier = Suppliers.memoize(defaultSupplier::get);
        }

        public T get(ItemStack stack) {
            return (T)stack.getOrDefault(this.type, this.defaultSupplier.get());
        }

        @Override
        public DataComponentType<T> get() {
            return this.type.get();
        }
    }
}

