/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import de.cech12.bucketlib.api.BucketLib;
import de.cech12.bucketlib.api.BucketLibTags;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.model.CompositeModel;
import net.neoforged.neoforge.client.model.DynamicFluidContainerModel;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class UniversalBucketModel
implements IUnbakedGeometry<UniversalBucketModel> {
    private static final Map<ResourceLocation, ResourceLocation> TEXTURE_MAP = Maps.newHashMap();
    private static final Transformation DEPTH_OFFSET_TRANSFORM = new Transformation(new Vector3f(), new Quaternionf(), new Vector3f(1.0f, 1.0f, 1.002f), new Quaternionf());
    private static final Material MISSING_LOWER_CONTENT_MATERIAL = new Material(InventoryMenu.BLOCK_ATLAS, UniversalBucketModel.getContentTexture(BucketLib.id("missing_lower_content")));
    @Nonnull
    private final Fluid fluid;
    @Nullable
    private final ResourceLocation otherContent;
    private final boolean isCracked;
    private final boolean isLower;

    public UniversalBucketModel(@Nonnull Fluid fluid, @Nullable ResourceLocation otherContent, boolean isCracked, boolean isLower) {
        this.fluid = fluid;
        this.otherContent = otherContent;
        this.isCracked = isCracked;
        this.isLower = isLower;
    }

    public UniversalBucketModel withFluid(Fluid newFluid, boolean isCracked) {
        return new UniversalBucketModel(newFluid, null, isCracked, false);
    }

    public UniversalBucketModel withOtherContent(ResourceLocation otherContent, boolean isCracked, boolean isLower) {
        return new UniversalBucketModel(Fluids.EMPTY, otherContent, isCracked, isLower);
    }

    public static ResourceLocation getContentTexture(ResourceLocation otherContentLocation) {
        ResourceLocation texture = TEXTURE_MAP.get(otherContentLocation);
        if (texture == null) {
            String textureLocation = String.format("item/bucket_content/%s", otherContentLocation.getPath());
            texture = otherContentLocation.withPath(textureLocation);
            TEXTURE_MAP.put(otherContentLocation, texture);
        }
        return texture;
    }

    @Nonnull
    public BakedModel bake(IGeometryBakingContext owner, @Nonnull ModelBaker baker, @Nonnull Function<Material, TextureAtlasSprite> spriteGetter, @Nonnull ModelState modelState, @Nonnull ItemOverrides overrides) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = owner.hasMaterial("particle") ? owner.getMaterial("particle") : null;
        Material baseLocation = null;
        if (this.isLower) {
            if (this.isCracked && owner.hasMaterial("crackedLowerBase")) {
                baseLocation = owner.getMaterial("crackedLowerBase");
            }
            if (baseLocation == null && owner.hasMaterial("lowerBase")) {
                baseLocation = owner.getMaterial("lowerBase");
            }
        } else {
            if (this.isCracked && owner.hasMaterial("crackedBase")) {
                baseLocation = owner.getMaterial("crackedBase");
            }
            if (baseLocation == null && owner.hasMaterial("base")) {
                baseLocation = owner.getMaterial("base");
            }
        }
        Material otherContentLocation = null;
        Material fluidLocation = null;
        Material fluidMaskLocation = null;
        if (this.otherContent != null) {
            otherContentLocation = new Material(InventoryMenu.BLOCK_ATLAS, UniversalBucketModel.getContentTexture(this.otherContent));
        }
        if (this.fluid != Fluids.EMPTY) {
            fluidLocation = new Material(InventoryMenu.BLOCK_ATLAS, UniversalBucketModel.getContentTexture(BuiltInRegistries.FLUID.getKey((Object)this.fluid)));
            if (this.isCracked && owner.hasMaterial("crackedFluidMask")) {
                fluidMaskLocation = owner.getMaterial("crackedFluidMask");
            }
            if (fluidMaskLocation == null && owner.hasMaterial("fluidMask")) {
                fluidMaskLocation = owner.getMaterial("fluidMask");
            }
        }
        if (otherContentLocation == null && fluidLocation != null && !MissingTextureAtlasSprite.getLocation().equals((Object)spriteGetter.apply(fluidLocation).contents().name())) {
            otherContentLocation = fluidLocation;
        }
        TextureAtlasSprite baseSprite = baseLocation != null ? spriteGetter.apply(baseLocation) : null;
        TextureAtlasSprite otherContentSprite = null;
        if (otherContentLocation != null) {
            otherContentSprite = spriteGetter.apply(otherContentLocation);
            if (MissingTextureAtlasSprite.getLocation().equals((Object)otherContentSprite.contents().name())) {
                otherContentSprite = spriteGetter.apply(MISSING_LOWER_CONTENT_MATERIAL);
            }
        }
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.EMPTY ? spriteGetter.apply(ClientHooks.getBlockMaterial((ResourceLocation)IClientFluidTypeExtensions.of((Fluid)this.fluid).getStillTexture())) : null;
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = baseSprite;
        }
        if (particleSprite == null) {
            particleSprite = otherContentSprite;
        }
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (this.fluid != Fluids.EMPTY && !this.fluid.defaultFluidState().is(BucketLibTags.Fluids.NO_FLIPPING) && this.fluid.getFluidType().isLighterThanAir()) {
            modelState = new SimpleModelState(modelState.getRotation().compose(new Transformation(null, new Quaternionf(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)owner).withGui3d(false).withUseBlockLight(false).build(BucketLib.id("universal_bucket"));
        CompositeModel.Baked.Builder modelBuilder = CompositeModel.Baked.builder((IGeometryBakingContext)itemContext, (TextureAtlasSprite)particleSprite, (ItemOverrides)new ContainedFluidOverrideHandler(overrides, baker, (IGeometryBakingContext)itemContext, this), (ItemTransforms)owner.getTransforms());
        RenderTypeGroup normalRenderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)false);
        if (baseSprite != null) {
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)baseSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> baseSprite, (ModelState)modelState);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        }
        if (otherContentSprite != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.getRotation().compose(DEPTH_OFFSET_TRANSFORM), modelState.isUvLocked());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)2, (TextureAtlasSprite)otherContentSprite);
            TextureAtlasSprite finalOtherContentSprite = otherContentSprite;
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> finalOtherContentSprite, (ModelState)transformedState);
            modelBuilder.addQuads(normalRenderTypes, (Collection)quads);
        } else if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            SimpleModelState transformedState = new SimpleModelState(modelState.getRotation().compose(DEPTH_OFFSET_TRANSFORM), modelState.isUvLocked());
            List unbaked = UnbakedGeometryHelper.createUnbakedItemMaskElements((int)1, (TextureAtlasSprite)templateSprite);
            List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> fluidSprite, (ModelState)transformedState);
            boolean emissive = this.fluid.getFluidType().getLightLevel() > 0;
            RenderTypeGroup renderTypes = DynamicFluidContainerModel.getLayerRenderTypes((boolean)emissive);
            if (emissive) {
                QuadTransformers.settingEmissivity((int)this.fluid.getFluidType().getLightLevel()).processInPlace(quads);
            }
            modelBuilder.addQuads(renderTypes, (Collection)quads);
        }
        modelBuilder.setParticle(particleSprite);
        return modelBuilder.build();
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;
        private final UniversalBucketModel parent;
        private Integer upperBreakTemperature = null;
        private Integer lowerBreakTemperature = null;

        private ContainedFluidOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner, UniversalBucketModel parent) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
            this.parent = parent;
        }

        @Nullable
        public BakedModel resolve(@Nonnull BakedModel originalModel, @Nonnull ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int number) {
            BakedModel overridden = this.nested.resolve(originalModel, stack, world, entity, number);
            if (overridden != originalModel) {
                return overridden;
            }
            Item item = stack.getItem();
            if (item instanceof UniversalBucketItem) {
                BakedModel bakedModel;
                UniversalBucketItem bucket = (UniversalBucketItem)item;
                boolean containsEntityType = false;
                String content = BucketLibUtil.getEntityTypeString(stack);
                if (content != null) {
                    containsEntityType = true;
                } else {
                    content = BucketLibUtil.getContentString(stack);
                }
                Fluid fluid = null;
                if (content == null) {
                    fluid = BucketLibUtil.getFluid(stack);
                    ResourceLocation location = BuiltInRegistries.FLUID.getKey((Object)fluid);
                    String string = content = location != BuiltInRegistries.FLUID.getDefaultKey() ? location.toString() : null;
                }
                if (!Objects.equals(this.upperBreakTemperature, bucket.getUpperBreakTemperature()) || !Objects.equals(this.lowerBreakTemperature, bucket.getLowerBreakTemperature())) {
                    this.upperBreakTemperature = bucket.getUpperBreakTemperature();
                    this.lowerBreakTemperature = bucket.getLowerBreakTemperature();
                    this.cache.clear();
                }
                if ((bakedModel = this.cache.get(content)) == null && content != null) {
                    boolean isCracked = bucket.isCracked(stack);
                    UniversalBucketModel unbaked = fluid == null ? this.parent.withOtherContent(ResourceLocation.parse((String)content), isCracked, containsEntityType) : this.parent.withFluid(fluid, isCracked);
                    bakedModel = unbaked.bake(this.owner, this.baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, this);
                    this.cache.put(content, bakedModel);
                }
                return bakedModel;
            }
            return originalModel;
        }
    }

    public static final class Loader
    implements IGeometryLoader<UniversalBucketModel> {
        public static final Loader INSTANCE = new Loader();

        @Nonnull
        public UniversalBucketModel read(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext deserializationContext) {
            return new UniversalBucketModel(Fluids.EMPTY, null, false, false);
        }
    }
}

