/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.items;

import java.util.List;
import javax.annotation.Nonnull;
import mob_grinding_utils.components.MGUComponents;
import mob_grinding_utils.util.RL;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemGMChickenFeed
extends Item {
    public FeedType type;

    public ItemGMChickenFeed(Item.Properties properties, FeedType typeIn) {
        super(properties);
        this.type = typeIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, @Nonnull Item.TooltipContext context, List<Component> list, @Nonnull TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"tooltip.chickenfeed_1").withStyle(ChatFormatting.YELLOW));
        list.add((Component)Component.translatable((String)"tooltip.chickenfeed_2").withStyle(ChatFormatting.YELLOW));
        if (this.type == FeedType.MOB && stack.has(MGUComponents.MOB_DNA)) {
            list.add((Component)Component.translatable((String)"tooltip.chickenfeed_3").withStyle(ChatFormatting.GREEN).append(String.valueOf(stack.getOrDefault(MGUComponents.MOB_DNA, (Object)RL.mc("nobody"))) + " 'DNA'."));
        }
        if (this.type == FeedType.CURSED) {
            list.add((Component)Component.translatable((String)"tooltip.chickenfeed_4").withStyle(ChatFormatting.YELLOW));
        }
        if (this.type == FeedType.NUTRITIOUS) {
            list.add((Component)Component.translatable((String)"tooltip.chickenfeed_5").withStyle(ChatFormatting.YELLOW));
        }
    }

    public static enum FeedType {
        MOB,
        CURSED,
        NUTRITIOUS;

    }
}

