/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.world.phys.Vec3;

public class MiscUtils {
    public static double straightLineDistance(BlockPos a, BlockPos b) {
        double deltaX = Math.abs(a.getX() - b.getX());
        double deltaY = Math.abs(a.getY() - b.getY());
        double deltaZ = Math.abs(a.getZ() - b.getZ());
        return Math.sqrt(Math.pow(deltaX, 2.0) + Math.pow(deltaY, 2.0) + Math.pow(deltaZ, 2.0));
    }

    public static float randomInRange(float min, float max) {
        return (float)((double)min + Math.random() * (double)(max - min));
    }

    public static int randomIntInRange(int min, int max) {
        return (int)Math.floor(MiscUtils.randomInRange(min, max + 1));
    }

    public static int weightedRandInt(int min, int max, float bias) {
        boolean passthrough = bias == 0.0f || min == max;
        boolean fail = min > max || max - min >= 100 || Math.abs(bias) >= 10.0f;
        String message = "[Cognition] Unable to use weighted randInt function, defaulting to unweighted ver. Check that all parameters are within bounds.";
        if (fail || passthrough) {
            if (fail) {
                System.out.println(message);
            }
            return MiscUtils.randomIntInRange(min, max);
        }
        int range = max - min;
        float step = (float)((Math.pow(2.0, bias) - 1.0) / (double)range);
        float cumSum = 0.0f;
        for (int i = 0; i <= range; ++i) {
            float weight = 1.0f + step * (float)i;
            cumSum += weight;
        }
        float cumRand = MiscUtils.randomInRange(0.0f, cumSum);
        for (int j = 0; j <= range; ++j) {
            float weight = 1.0f + step * (float)j;
            if (!((cumRand -= weight) <= 0.0f)) continue;
            return j + min;
        }
        System.out.println(message);
        return MiscUtils.randomIntInRange(min, max);
    }

    public static float coinflip(float a, float b) {
        return Math.random() <= 0.5 ? a : b;
    }

    public static Vec3 generateRandomBlockSurfacePos(BlockPos pos, float distanceFromCtr) {
        double x = pos.getCenter().x;
        double y = pos.getCenter().y;
        double z = pos.getCenter().z;
        double rand = Math.random();
        if (rand <= 0.33) {
            x += (double)MiscUtils.coinflip(-distanceFromCtr, distanceFromCtr);
            y += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
            z += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
        } else if (rand <= 0.66) {
            x += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
            y += (double)MiscUtils.coinflip(-distanceFromCtr, distanceFromCtr);
            z += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
        } else {
            x += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
            y += (double)MiscUtils.randomInRange(-distanceFromCtr, distanceFromCtr);
            z += (double)MiscUtils.coinflip(-distanceFromCtr, distanceFromCtr);
        }
        return new Vec3(x, y, z);
    }

    public static List<String> getLinesFromString(String input, int lineWidth, Font font) {
        List lines = font.getSplitter().splitLines(input, lineWidth, Style.EMPTY);
        ArrayList<String> outputLines = new ArrayList<String>();
        for (FormattedText line : lines) {
            outputLines.add(line.getString());
        }
        return outputLines;
    }

    public static Map<String, Float> getExperienceItemMapFromList(List<String> list) {
        HashMap<String, Float> map = new HashMap<String, Float>();
        for (String element : list) {
            String[] substrings = element.split(" = ");
            if (substrings.length != 2) continue;
            String itemName = substrings[0];
            String xp = substrings[1];
            if (!MiscUtils.isValidFloat(xp)) continue;
            map.put(itemName, Float.valueOf(xp));
        }
        return map;
    }

    public static boolean isValidFloat(String n) {
        try {
            Float.valueOf(n);
            return true;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }
}

