/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.network.shared;

import io.netty.buffer.ByteBuf;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateInventory(CompoundTag container) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, UpdateInventory> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.COMPOUND_TAG, UpdateInventory::container, UpdateInventory::new);
    public static final CustomPacketPayload.Type<UpdateInventory> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cognition", (String)"update_inventory"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleServer(UpdateInventory packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            if (!context.player().level().isClientSide) {
                ServerPlayer player = (ServerPlayer)context.player();
                ListTag list = packet.container.getList("Container", 10);
                for (Slot slot : player.containerMenu.slots) {
                    CompoundTag tag = list.getCompound(slot.index);
                    ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)player.level().registryAccess(), (CompoundTag)tag);
                    slot.set(item);
                }
            }
        });
    }
}

