/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.cognition.item;

import com.cyanogen.cognition.registries.RegisterSounds;
import com.cyanogen.cognition.utils.ExperienceUtils;
import com.cyanogen.cognition.utils.MiscUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FlaskHadesItem
extends BucketItem {
    public static final int cost = 160;
    final int cooldown = 25;
    private final FluidStack fluidStack = new FluidStack(Fluids.LAVA.getSource(), 1000);

    public FlaskHadesItem(Item.Properties p) {
        super(Fluids.LAVA.getSource(), p);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        BlockHitResult blockhitresult = FlaskHadesItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.content == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        Direction direction = blockhitresult.getDirection();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (!level.mayInteract(player, blockpos) || !player.mayUseItemAt(blockpos1, direction, itemstack)) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        if (this.canUse(player)) {
            BlockPos blockpos2;
            BlockState blockstate = level.getBlockState(blockpos);
            BlockPos blockPos = blockpos2 = this.canBlockContainFluid(player, level, blockpos, blockstate) ? blockpos : blockpos1;
            if (this.emptyContents(player, level, blockpos2, blockhitresult, itemstack)) {
                this.checkExtraContent(player, level, itemstack, blockpos2);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, blockpos2, itemstack);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                this.handlePlayer(player);
                return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
            }
            return InteractionResultHolder.fail((Object)itemstack);
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        if (player != null && (player.isCreative() || ExperienceUtils.getTotalXP(player) >= 160L) && !player.getCooldowns().isOnCooldown((Item)this)) {
            boolean canModifyClicked = level.mayInteract(player, clickedPos) && player.mayUseItemAt(clickedPos, context.getClickedFace(), player.getItemInHand(context.getHand()));
            boolean edit = !player.isShiftKeyDown() && canModifyClicked;
            BlockState clickedState = level.getBlockState(clickedPos);
            if (clickedState.getBlock() instanceof AbstractCauldronBlock && edit) {
                if (clickedState.getBlock().equals(Blocks.CAULDRON)) {
                    level.setBlockAndUpdate(clickedPos, Blocks.LAVA_CAULDRON.defaultBlockState());
                    this.handlePlayer(player);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return InteractionResult.FAIL;
            }
            if (clickedState.hasBlockEntity() && edit) {
                int drainAmount;
                BlockEntity entity = level.getBlockEntity(clickedPos);
                assert (entity != null);
                IFluidHandler handler = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, clickedPos, (Object)direction);
                if (handler != null && (drainAmount = handler.fill(this.fluidStack, IFluidHandler.FluidAction.SIMULATE)) != 0) {
                    handler.fill(this.fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    this.handlePlayer(player);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public boolean canUse(Player player) {
        return (player.isCreative() || ExperienceUtils.getTotalXP(player) >= 160L) && !player.getCooldowns().isOnCooldown((Item)this);
    }

    public void handlePlayer(Player player) {
        int k = player.isCreative() ? 0 : 1;
        player.getCooldowns().addCooldown((Item)this, 25);
        player.giveExperiencePoints(-160 * k);
        player.playSound((SoundEvent)RegisterSounds.FLASK_EMPTY_LAVA.get(), MiscUtils.randomInRange(0.8f, 1.0f), MiscUtils.randomInRange(0.8f, 1.0f));
    }
}

