/*
 * Decompiled with CFR 0.152.
 */
package com.ofekn.crafting_on_a_stick.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.ofekn.crafting_on_a_stick.COASConfig;
import com.ofekn.crafting_on_a_stick.COASUtils;
import com.ofekn.crafting_on_a_stick.api.IWheelItem;
import com.ofekn.crafting_on_a_stick.api.Ref;
import com.ofekn.crafting_on_a_stick.client.COASKeyMappings;
import com.ofekn.crafting_on_a_stick.client.ListWheelLayout;
import com.ofekn.crafting_on_a_stick.client.RoundWheelLayout;
import com.ofekn.crafting_on_a_stick.client.WheelLayoutSupplier;
import com.ofekn.crafting_on_a_stick.client.WheelPolygon;
import com.ofekn.crafting_on_a_stick.network.SBOpen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Vector2f;

public class COASWheelScreen
extends Screen {
    public static final List<WheelLayoutSupplier> POSSIBLE_LAYOUTS = new ArrayList<WheelLayoutSupplier>();
    private static ItemStack lastSelection;
    private final Player player;
    private ItemStack selectionItem;
    private int selectionIndex;
    private WheelLayoutSupplier layoutSupplier = RoundWheelLayout.INSTANCE;
    private int openTick;

    public static void trigger(Minecraft minecraft, Player player) {
        List<ItemStack> options = COASWheelScreen.getOptions(player);
        if (options.isEmpty()) {
            return;
        }
        ItemStack firstOption = options.getFirst();
        if (options.size() == 1 || !COASKeyMappings.OPEN_CURIOS_KEY.isDown()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SBOpen(firstOption), (CustomPacketPayload[])new CustomPacketPayload[0]);
            return;
        }
        minecraft.setScreen((Screen)new COASWheelScreen((Component)Component.empty(), player, firstOption));
    }

    protected COASWheelScreen(Component title, Player player, ItemStack firstOption) {
        super(title);
        this.player = player;
        this.selectionItem = firstOption;
        this.selectionIndex = 0;
        this.openTick = 0;
        String layoutName = ((String)COASConfig.Client.WHEEL_TYPE.get()).toLowerCase();
        for (WheelLayoutSupplier possibleLayout : POSSIBLE_LAYOUTS) {
            if (!possibleLayout.getSerializedName().equals(layoutName)) continue;
            this.layoutSupplier = possibleLayout;
            break;
        }
        if (this.layoutSupplier == null) {
            this.layoutSupplier = POSSIBLE_LAYOUTS.getFirst();
            COASConfig.Client.WHEEL_TYPE.set((Object)this.layoutSupplier.getSerializedName());
        }
    }

    public static List<ItemStack> getOptions(Player player) {
        List<ItemStack> allOptions = COASUtils.getFullInventory(player).stream().map(Ref::get).map(stack -> {
            ItemStack itemStack;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof IWheelItem) {
                IWheelItem item = (IWheelItem)patt0$temp;
                itemStack = item.getWheelRepresentative(player, (ItemStack)stack);
            } else {
                itemStack = ItemStack.EMPTY;
            }
            return itemStack;
        }).filter(stack -> !stack.isEmpty()).toList();
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack2 : allOptions) {
            boolean isDuplicate = false;
            for (ItemStack existing : result) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack2, (ItemStack)existing)) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate) continue;
            result.add(stack2);
        }
        for (int i = 0; i < result.size(); ++i) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)result.get(i)), (ItemStack)lastSelection)) continue;
            result.remove(i);
            result.addFirst(lastSelection);
            break;
        }
        return result;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.select();
            return true;
        }
        if (button == 1) {
            int index = POSSIBLE_LAYOUTS.indexOf(this.layoutSupplier);
            int newIndex = (index + 1) % POSSIBLE_LAYOUTS.size();
            this.layoutSupplier = POSSIBLE_LAYOUTS.get(newIndex);
            COASConfig.Client.WHEEL_TYPE.set((Object)this.layoutSupplier.getSerializedName());
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
        super.tick();
        ++this.openTick;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (!COASKeyMappings.OPEN_CURIOS_KEY.isDown()) {
            this.select();
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    private void select() {
        this.onClose();
        if (!this.selectionItem.isEmpty()) {
            lastSelection = this.selectionItem;
            PacketDistributor.sendToServer((CustomPacketPayload)new SBOpen(this.selectionItem), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void mouseMoved(double mouseX, double mouseY) {
        super.mouseMoved(mouseX, mouseY);
        float dmx = (float)mouseX - (float)this.width / 2.0f;
        float dmy = (float)mouseY - (float)this.height / 2.0f;
        List<ItemStack> options = COASWheelScreen.getOptions(this.player);
        WheelPolygon[] layout = this.getLayout(options.size());
        float smallestDistance = Float.POSITIVE_INFINITY;
        int newSelection = 0;
        for (int i = 0; i < layout.length; ++i) {
            for (Vector2f point : layout[i].points()) {
                float distance = point.distanceSquared(dmx, dmy);
                if (!(distance < smallestDistance)) continue;
                smallestDistance = distance;
                newSelection = i;
            }
        }
        this.selectionIndex = newSelection;
        this.selectionItem = newSelection < options.size() ? options.get(newSelection) : ItemStack.EMPTY;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        PoseStack pos = guiGraphics.pose();
        float t = Math.min(1.0f, this.getAnimationT(partialTick));
        List<ItemStack> options = COASWheelScreen.getOptions(this.player);
        int numOptions = options.size();
        float centerX = (float)this.width * 0.5f;
        float centerY = (float)this.height * 0.5f;
        if (numOptions == 0) {
            int textColor = this.applyAlpha(-1, t);
            guiGraphics.drawCenteredString(this.font, (Component)Component.translatable((String)"gui.crafting_on_a_stick.selection_wheel.no_tool"), (int)centerX, (int)centerY, textColor);
            return;
        }
        float scale = this.easeScale(t);
        pos.pushPose();
        pos.translate(centerX, centerY, 0.0f);
        pos.scale(scale, scale, 1.0f);
        WheelPolygon[] layout = this.getLayout(numOptions);
        for (int i = 0; i < numOptions; ++i) {
            WheelPolygon polygon = layout[i];
            int baseColor = this.selectionIndex == i ? -1 : -2130706433;
            polygon.fill(guiGraphics, RenderType.gui(), 0.0f, this.applyAlpha(baseColor, t));
            float x = polygon.center().x;
            float y = polygon.center().y;
            pos.pushPose();
            pos.translate(x, y, 0.0f);
            guiGraphics.renderFakeItem(options.get(i), -8, -8);
            pos.popPose();
            if (this.selectionIndex != i) continue;
            int overlayColor = this.applyAlpha(Integer.MAX_VALUE, t);
            polygon.fill(guiGraphics, RenderType.guiOverlay(), 10.0f, overlayColor);
        }
        pos.popPose();
        if (t > 0.99f) {
            guiGraphics.renderTooltip(this.font, this.selectionItem, mouseX, mouseY);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float t = this.getAnimationT(partialTick);
        guiGraphics.fill(0, 0, this.width, this.height, this.applyAlpha(0x40000000, t));
    }

    private float easeScale(float t) {
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        return (float)(1.0 + (double)c3 * Math.pow(t - 1.0f, 3.0) + (double)c1 * Math.pow(t - 1.0f, 2.0));
    }

    private float getAnimationT(float partialTick) {
        float t = ((float)this.openTick + partialTick - 4.0f) / 6.0f;
        return Math.clamp(t, 0.0f, 1.0f);
    }

    private int applyAlpha(int color, float t) {
        int a = (int)((float)(color >>> 24) * t) & 0xFF;
        return a << 24 | color & 0xFFFFFF;
    }

    private WheelPolygon[] getLayout(int numOptions) {
        return (WheelPolygon[])this.layoutSupplier.apply(numOptions);
    }

    static {
        POSSIBLE_LAYOUTS.add(RoundWheelLayout.INSTANCE);
        POSSIBLE_LAYOUTS.add(ListWheelLayout.INSTANCE);
        lastSelection = ItemStack.EMPTY;
    }
}

