/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.handler;

import com.mojang.logging.LogUtils;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Optional;
import mod.chiselsandbits.ChiselsAndBits;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import org.slf4j.Logger;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class AddPackFindersEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        event.addRepositorySource(registrar -> {
            try {
                Path coreJarPath = Path.of(ChiselsAndBits.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                PackLocationInfo packLocationInfo = new PackLocationInfo("chiselsandbits-core", (Component)Component.literal((String)"Chisels & Bits Core"), PackSource.BUILT_IN, Optional.of(new KnownPack("chiselsandbits", "core", ModList.get().getModFileById("chiselsandbits").versionString())));
                PathPackResources packResources = new PathPackResources(packLocationInfo, coreJarPath);
                Pack pack = Pack.readMetaAndCreate((PackLocationInfo)packLocationInfo, (Pack.ResourcesSupplier)new SinglePackResourceResourcesSupplier((PackResources)packResources), (PackType)event.getPackType(), (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, true));
                registrar.accept(pack);
            }
            catch (URISyntaxException e) {
                LOGGER.error("Failed to inject Core Resource Pack. C&B Assets will not be loaded!", (Throwable)e);
            }
        });
    }

    private record SinglePackResourceResourcesSupplier(PackResources packResources) implements Pack.ResourcesSupplier
    {
        public PackResources openPrimary(PackLocationInfo location) {
            return this.packResources();
        }

        public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
            return this.packResources();
        }
    }
}

