/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.model;

import com.communi.suggestu.scena.core.registries.deferred.IRegistryObject;
import java.util.Objects;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.model.generators.CustomLoaderBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class ChiselBlockItemModelGenerator
extends ItemModelProvider
implements DataProvider {
    private static final ResourceLocation LOADER = ResourceLocation.fromNamespaceAndPath((String)"chiselsandbits", (String)"chiseled_block");

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new ChiselBlockItemModelGenerator(event.getGenerator(), event.getExistingFileHelper()));
    }

    public ChiselBlockItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "chiselsandbits", existingFileHelper);
    }

    protected void registerModels() {
        this.actOnBlockWithLoader((Block)ModBlocks.CHISELED_BLOCK.get());
        this.actOnItemWithLoader((Item)ModItems.CHISELED_BLOCK.get());
        ModItems.LEGACY_MATERIAL_CHISELED_BLOCKS.stream().map(IRegistryObject::get).forEach(item -> ((ItemModelBuilder)this.getBuilder(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey(item)).getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated"))));
    }

    public void actOnBlockWithLoader(Block block) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated")))).customLoader((itemModelBuilder, existingFileHelper) -> new CustomLoaderBuilder<ItemModelBuilder>(this, LOADER, itemModelBuilder, existingFileHelper, false){});
    }

    public void actOnItemWithLoader(Item item) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/generated")))).customLoader((itemModelBuilder, existingFileHelper) -> new CustomLoaderBuilder<ItemModelBuilder>(this, LOADER, itemModelBuilder, existingFileHelper, false){});
    }

    @NotNull
    public String getName() {
        return "Chisel block item model generator";
    }
}

