/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.loottable;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import mod.chiselsandbits.registrars.ModBlocks;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.WritableRegistry;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class DropBlockLootTableGenerator
extends LootTableProvider {
    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new DropBlockLootTableGenerator(event.getGenerator().getPackOutput(), FeatureFlags.REGISTRY.allFlags(), event.getLookupProvider()));
    }

    private DropBlockLootTableGenerator(PackOutput packOutput, FeatureFlagSet featureFlagSet, CompletableFuture<HolderLookup.Provider> registries) {
        super(packOutput, Set.of(), DropBlockLootTableGenerator.createTables(featureFlagSet), registries);
    }

    protected void validate(@NotNull WritableRegistry<LootTable> writableregistry, @NotNull ValidationContext validationcontext, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ProblemReporter.Collector problemreporter$collector) {
    }

    @NotNull
    private static List<LootTableProvider.SubProviderEntry> createTables(FeatureFlagSet featureFlagSet) {
        return ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(provider -> new SelfDroppingBlocks(featureFlagSet, (HolderLookup.Provider)provider), LootContextParamSets.BLOCK));
    }

    private static final class SelfDroppingBlocks
    extends BlockLootSubProvider {
        private SelfDroppingBlocks(FeatureFlagSet featureFlagSet, HolderLookup.Provider registries) {
            super(Set.of(), featureFlagSet, registries);
        }

        protected void generate() {
            this.dropSelf((Block)ModBlocks.CHISELED_PRINTER.get());
            this.dropSelf((Block)ModBlocks.MODIFICATION_TABLE.get());
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            return ImmutableList.of((Object)((Block)ModBlocks.CHISELED_PRINTER.get()), (Object)((Block)ModBlocks.MODIFICATION_TABLE.get()));
        }
    }
}

