/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.lang;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.LocalStrings;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="chiselsandbits", bus=EventBusSubscriber.Bus.MOD)
public class LangEntryLangGenerator
implements DataProvider {
    private final PackOutput generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().addProvider(true, (DataProvider)new LangEntryLangGenerator(event.getGenerator().getPackOutput()));
    }

    private LangEntryLangGenerator(PackOutput generator) {
        this.generator = generator;
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        List langKeys = Arrays.stream(LocalStrings.values()).map(LocalStrings::toString).collect(Collectors.toList());
        Collections.sort(langKeys);
        JsonObject returnValue = new JsonObject();
        for (String langKey : langKeys) {
            returnValue.addProperty(langKey, "");
        }
        Path configLangFolder = this.generator.getOutputFolder().resolve("assets/chiselsandbits/lang/config/");
        Path langPath = configLangFolder.resolve("localstrings.json");
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)returnValue, (Path)langPath);
    }

    @NotNull
    public String getName() {
        return "Local strings lang generator";
    }
}

