/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.client.block;

import mod.chiselsandbits.api.block.entity.IMultiStateBlockEntity;
import mod.chiselsandbits.utils.EffectUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeClientChiseledBlockExtensions
implements IClientBlockExtensions {
    @Nullable
    private BlockState getPrimaryState(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof IMultiStateBlockEntity)) {
            return null;
        }
        IMultiStateBlockEntity multiStateBlockEntity = (IMultiStateBlockEntity)blockEntity;
        return multiStateBlockEntity.getStatistics().getPrimaryState().blockState();
    }

    public boolean addHitEffects(@NotNull BlockState state, @NotNull Level level, @NotNull HitResult target, @NotNull ParticleEngine engine) {
        BlockHitResult blockTarget;
        block5: {
            block4: {
                if (!(target instanceof BlockHitResult)) break block4;
                blockTarget = (BlockHitResult)target;
                if (target.getType() != HitResult.Type.MISS) break block5;
            }
            return false;
        }
        BlockState primaryState = this.getPrimaryState(level, blockTarget.getBlockPos());
        if (primaryState == null) {
            return false;
        }
        return EffectUtils.addHitEffects((Level)level, (BlockHitResult)blockTarget, (BlockState)primaryState, (ParticleEngine)engine);
    }

    public boolean addDestroyEffects(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull ParticleEngine engine) {
        BlockState primaryState = this.getPrimaryState(level, pos);
        if (primaryState == null) {
            return false;
        }
        EffectUtils.addBlockDestroyEffects((LevelReader)level, (BlockPos)pos, (BlockState)primaryState, (ParticleEngine)Minecraft.getInstance().particleEngine, (Level)level);
        return true;
    }
}

