/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.render.tile;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.FluidStack;
import owmii.powah.block.magmator.MagmatorTile;
import owmii.powah.client.ClientUtils;
import owmii.powah.lib.client.renderer.tile.AbstractTileRenderer;
import owmii.powah.lib.client.util.Render;
import owmii.powah.lib.logistics.fluid.Tank;

public class MagmatorRenderer
extends AbstractTileRenderer<MagmatorTile> {
    protected MagmatorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void render(MagmatorTile te, float pt, PoseStack matrix, MultiBufferSource rtb, Minecraft mc, ClientLevel world, LocalPlayer player, int light, int ov) {
        FluidStack fluidStack;
        TextureAtlasSprite sprite;
        Tank tank = te.getTank();
        if (!tank.isEmpty() && (sprite = ClientUtils.getStillTexture(fluidStack = tank.getFluid())) != null) {
            int color = ClientUtils.getFluidColor(fluidStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
            VertexConsumer buffer = rtb.getBuffer(RenderType.text((ResourceLocation)sprite.atlasLocation()));
            matrix.pushPose();
            float fill = (float)tank.getFluidAmount() * 0.45f / (float)tank.getCapacity();
            matrix.translate(0.1875, 0.51 + (double)fill, 0.1875);
            matrix.scale(0.625f, 1.0f, 0.625f);
            Render.quad(matrix.last().pose(), buffer, sprite, 1.0f, 1.0f, red, green, blue);
            matrix.popPose();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

