/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.client.model.AbstractModel;
import owmii.powah.client.render.tile.ReactorRenderer;

public class ReactorModel
extends AbstractModel<ReactorTile, ReactorRenderer> {
    private static final String REACTOR = "reactor";
    private final ModelPart reactor;

    public ReactorModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.reactor = root.getChild(REACTOR);
    }

    public static LayerDefinition createDefinition() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.getRoot();
        root.addOrReplaceChild(REACTOR, CubeListBuilder.create().mirror().addBox(-24.0f, -32.0f, -24.0f, 48.0f, 64.0f, 48.0f), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)256, (int)128);
    }

    @Override
    public void render(ReactorTile te, ReactorRenderer renderer, PoseStack matrix, MultiBufferSource rtb, int light, int ov) {
        VertexConsumer buffer_on;
        VertexConsumer buffer = rtb.getBuffer(this.renderType(Powah.id("textures/model/tile/reactor.png")));
        this.reactor.render(matrix, buffer, light, ov);
        int i = 0xF000F0 - light;
        int i1 = (int)((float)i * te.bright.subSized());
        int br = light + i1;
        if (te.isRunning()) {
            buffer_on = rtb.getBuffer(this.renderType(Powah.id("textures/model/tile/reactor_on.png")));
            this.reactor.render(matrix, buffer_on, light, ov);
        }
        if (!te.fuel.isEmpty()) {
            buffer_on = rtb.getBuffer(this.renderType(Powah.id("textures/model/tile/reactor_filled.png")));
            this.reactor.render(matrix, buffer_on, br, ov);
        }
        if (te.getVariant() != Tier.STARTER) {
            VertexConsumer buffer_type = rtb.getBuffer(this.renderType(Powah.id("textures/model/tile/reactor_" + ((Tier)te.getVariant()).getName() + ".png")));
            this.reactor.render(matrix, buffer_type, light, ov);
        }
    }
}

