/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.client.model;

import com.kyanite.deeperdarker.content.entities.AnglerFish;
import com.kyanite.deeperdarker.content.entities.animations.AnglerFishAnimation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AnglerFishModel
extends HierarchicalModel<AnglerFish> {
    private final ModelPart root;

    public AnglerFishModel(ModelPart root) {
        this.root = root;
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition root = parts.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)8.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -4.0f, -5.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-4.0f));
        head.addOrReplaceChild("hook", CubeListBuilder.create().texOffs(24, -8).addBox(0.0f, -5.0f, -7.0f, 0.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)-3.5f));
        head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(16, 23).addBox(-2.0f, -0.5f, -4.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 28).addBox(-2.0f, -1.5f, -4.0f, 4.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.5f, (float)-5.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 12).addBox(-2.5f, -2.5f, 0.0f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.5f, (float)-3.0f));
        body.addOrReplaceChild("dorsalFin", CubeListBuilder.create().texOffs(24, 7).addBox(0.0f, -4.0f, -2.0f, 0.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.5f, (float)2.0f));
        body.addOrReplaceChild("leftFin", CubeListBuilder.create().texOffs(19, 18).mirror().addBox(2.0f, -1.0f, -1.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.5f, (float)2.5f, (float)1.0f));
        body.addOrReplaceChild("rightFin", CubeListBuilder.create().texOffs(19, 18).addBox(-7.0f, -1.0f, -1.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)2.5f, (float)1.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 22).addBox(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        tail.addOrReplaceChild("leftTail", CubeListBuilder.create().texOffs(19, 18).mirror().addBox(-0.5f, 0.0f, -2.5f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)1.5f, (float)1.0f, (float)2.5f));
        tail.addOrReplaceChild("rightTail", CubeListBuilder.create().texOffs(19, 18).addBox(-4.5f, 0.0f, -2.5f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.5f, (float)1.0f, (float)2.5f));
        tail.addOrReplaceChild("caudalFin", CubeListBuilder.create().texOffs(24, 1).addBox(0.0f, -3.5f, 0.0f, 0.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)48, (int)48);
    }

    public void setupAnim(AnglerFish entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        float f = 1.0f;
        float f1 = 1.0f;
        if (!entity.isInWater()) {
            f = 1.3f;
            f1 = 1.7f;
        }
        this.root.getChild((String)"root").getChild((String)"body").yRot = -f * 0.25f * Mth.sin((float)(f1 * 0.6f * ageInTicks));
        this.animate(entity.attackState, AnglerFishAnimation.BITE, ageInTicks);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.root.getChild("root").render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    public ModelPart root() {
        return this.root;
    }
}

