/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.checkerframework.checker.nullness.qual.NonNull;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.FakeExplosion;
import stepsword.mahoutsukai.util.Utils;

public class EffectUtil {
    public static ResourceLocation effectIcon = ResourceLocation.fromNamespaceAndPath((String)"mahoutsukai", (String)"textures/items/spell_scroll.png");
    public static BlockState AIR = Blocks.AIR.defaultBlockState();
    public static boolean DO_CANCEL_STACK_TRACE = false;

    public static boolean noMoreSoaring(LivingEntity player) {
        return player.onGround() || player.isFallFlying() || player.isUnderWater();
    }

    public static FakeExplosion createFakeExplosion(Entity target, Player player, Vec3 location, List<BlockPos> affected) {
        FakeExplosion explosion = new FakeExplosion(target.level(), (Entity)player, location.x, location.y, location.z, 10.0f, affected);
        return explosion;
    }

    public static void tryFakeExplosion(FakeExplosion explosion, List<BlockPos> affected, @NonNull Entity target, Player caster, boolean drop, ArrayList<Entity> entities, Vec3 location, int limit, ExplodeFunction<BlockState, Entity, Boolean, BlockPos, Boolean> fn) {
        if (!target.level().isClientSide) {
            Object player = caster == null ? SafeFakePlayer.createFakePlayerIfNull((ServerLevel)target.level()) : caster;
            boolean canceled = EventHooks.onExplosionStart((Level)target.level(), (Explosion)explosion);
            EventHooks.onExplosionDetonate((Level)target.level(), (Explosion)explosion, entities, (double)10.0);
            int cnt = 0;
            if (!canceled) {
                for (BlockPos p : affected) {
                    if (cnt >= limit && limit > -1) break;
                    BlockState bs = target.level().getBlockState(p);
                    boolean changed = fn.apply(bs, target, drop, p);
                    if (!changed) continue;
                    ++cnt;
                }
            }
        }
    }

    public static void tryFakeExplosion(FakeExplosion explosion, List<BlockPos> affected, @NonNull Entity target, Player caster, String name, boolean drop, ArrayList<Entity> entities) {
        EffectUtil.tryFakeExplosion(explosion, affected, target, caster, drop, entities, target.position(), -1, (bs, e, d, p) -> {
            if (!EffectUtil.unchangableBlock(bs.getBlock()) && !bs.isAir()) {
                if (d.booleanValue()) {
                    Block.dropResources((BlockState)bs, (LevelAccessor)e.level(), (BlockPos)p, (BlockEntity)e.level().getBlockEntity(p));
                }
                e.level().removeBlock(p, false);
                return true;
            }
            return false;
        });
    }

    public static void tryFakeExplosion(List<BlockPos> affected, @NonNull Entity target, Player caster, boolean drop, ArrayList<Entity> entities, Vec3 pos, int limit, ExplodeFunction<BlockState, Entity, Boolean, BlockPos, Boolean> fn) {
        EffectUtil.tryFakeExplosion(EffectUtil.createFakeExplosion(target, caster, caster.position(), affected), affected, target, caster, drop, entities, pos, limit, fn);
    }

    public static void buff(LivingEntity player, Holder<MobEffect> potion, boolean additiveBuff, int ticks) {
        EffectUtil.buff(player, potion, additiveBuff, ticks, true, 0);
    }

    public static void buff(LivingEntity player, Holder<MobEffect> potion, boolean additiveBuff, int ticks, boolean showparticles, int level) {
        MobEffectInstance e;
        int time = ticks;
        if (additiveBuff && player.hasEffect(potion) && (e = player.getEffect(potion)) != null && e.getDuration() > 0) {
            time += e.getDuration();
        }
        player.addEffect(new MobEffectInstance(potion, time, level, false, showparticles));
    }

    public static void buff(LivingEntity player, Holder<MobEffect> potion, boolean additiveBuff, int ticks, boolean showparticles) {
        EffectUtil.buff(player, potion, additiveBuff, ticks, showparticles, 0);
    }

    public static boolean hasBuff(LivingEntity e, Holder<MobEffect> potion) {
        return e != null && e.hasEffect(potion);
    }

    public static void debuff(LivingEntity e, Holder<MobEffect> potion) {
        if (EffectUtil.hasBuff(e, potion)) {
            e.removeEffect(potion);
        }
    }

    public static boolean inRange(LivingEntity victim, LivingEntity binder, Vec3 vicPos, int range, boolean facingRequired) {
        Vec3 look = binder.getLookAngle();
        Vec3 eyes = binder.getEyePosition(1.0f);
        if (EffectUtil.pointToLineDistance(vicPos, eyes, look.add(eyes)) < (double)range) {
            if (!facingRequired) {
                return EffectUtil.isLookingAtMe(victim, binder);
            }
            float facing = victim.getYRot() - binder.getYRot();
            if ((facing %= 360.0f) < 0.0f) {
                facing += 360.0f;
            }
            return facing > 90.0f && facing < 270.0f;
        }
        return false;
    }

    public static boolean isLookingAtMe(LivingEntity me, LivingEntity player) {
        return EffectUtil.isLookingAtMe((Entity)me, player, 0);
    }

    public static boolean isLookingAtMe(Entity me, LivingEntity player, int limit) {
        Vec3 mv = me.position();
        float angleToMe = (float)Math.atan2(mv.z - player.getZ(), mv.x - player.getX()) * 57.2958f;
        float yaw = player.getYRot();
        yaw %= 360.0f;
        angleToMe %= 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (angleToMe < 0.0f) {
            angleToMe += 360.0f;
        }
        float boundUpper = (yaw + 90.0f + 90.0f - (float)limit) % 360.0f;
        float boundLower = (yaw + (float)limit) % 360.0f;
        if (boundLower < 0.0f) {
            boundLower += 360.0f;
        }
        if (boundUpper < 0.0f) {
            boundUpper += 360.0f;
        }
        if (angleToMe < boundUpper && angleToMe > boundLower) {
            return true;
        }
        return boundUpper < boundLower && (angleToMe < boundUpper || angleToMe > boundLower);
    }

    public static void buff(LivingEntity player, Holder<MobEffect> potion, boolean additiveBuff, int ticks, int amplifier) {
        MobEffectInstance e;
        int time = ticks;
        if (additiveBuff && player.hasEffect(potion) && (e = player.getEffect(potion)) != null && e.getDuration() > 0) {
            time += e.getDuration();
        }
        player.addEffect(new MobEffectInstance(potion, time, amplifier));
    }

    public static int getBuffLevel(LivingEntity e, Holder<MobEffect> potion) {
        MobEffectInstance effect = e.getEffect(potion);
        if (effect != null) {
            return effect.getAmplifier();
        }
        return 0;
    }

    public static double pointToLineDistance(Vec3 point, Vec3 line1, Vec3 line2) {
        double d = line2.subtract(line1).cross(line1.subtract(point)).length();
        return d /= line2.distanceTo(line1);
    }

    public static Vec3 pointToCenter(Vec3 point, Vec3 line1, Vec3 line2) {
        Vec3 z = line2.subtract(line1).cross(line1.subtract(point));
        return z;
    }

    public static int getEffectDuration(LivingEntity e, Holder<MobEffect> p) {
        MobEffectInstance effect = e.getEffect(p);
        if (effect != null) {
            return effect.getDuration();
        }
        return 0;
    }

    public static void tryChangeBlockState(boolean killTE, BlockPos p, BlockState newstate, Level world, Player player) {
        EffectUtil.tryChangeBlockState(killTE, p, newstate, world, player, player == null ? null : player.getUUID());
    }

    public static boolean tryChangeBlockState(boolean killTE, BlockPos p, BlockState newstate, Level world, Player player, UUID uuid) {
        if (world != null && !world.isClientSide) {
            BlockState state = world.getBlockState(p);
            if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                MahouTsukaiMod.logger.debug("This log happens before we start doing anything.");
                MahouTsukaiMod.logger.debug("More info for debugging.");
                MahouTsukaiMod.logger.debug("player:" + String.valueOf(player));
                MahouTsukaiMod.logger.debug("uuid:" + String.valueOf(uuid));
                MahouTsukaiMod.logger.debug("block pos:" + String.valueOf(p));
                MahouTsukaiMod.logger.debug("world.getBlockState?" + String.valueOf(state));
                MahouTsukaiMod.logger.debug("unchangable?" + EffectUtil.unchangableBlock(state.getBlock()));
                MahouTsukaiMod.logger.debug("world.getBlockEntity?" + String.valueOf(world.getBlockEntity(p)));
            }
            if (EffectUtil.unchangableBlock(state.getBlock())) {
                return false;
            }
            if (!killTE && world.getBlockEntity(p) != null) {
                return false;
            }
            if (uuid != null) {
                player = SafeFakePlayer.createFakePlayerIfNotExists((ServerLevel)world, "faker", uuid);
            }
            if (player == null) {
                player = SafeFakePlayer.createFakePlayerIfNull((ServerLevel)world);
                if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                    MahouTsukaiMod.logger.debug("Created a fake player!");
                }
            }
            if (p != null && world != null && player != null && state != null) {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, p, state, player);
                NeoForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled()) {
                    if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                        MahouTsukaiMod.logger.debug("Trying to create lake blocks now!!");
                    }
                    world.setBlockAndUpdate(p, newstate);
                    return true;
                }
                if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                    MahouTsukaiMod.logger.debug("Block changes are failing because the block break event is being cancelled.");
                    MahouTsukaiMod.logger.debug("More info for debugging.");
                    MahouTsukaiMod.logger.debug("player:" + String.valueOf(player));
                    MahouTsukaiMod.logger.debug("uuid:" + String.valueOf(uuid));
                    MahouTsukaiMod.logger.debug("block pos:" + String.valueOf(p));
                    DO_CANCEL_STACK_TRACE = true;
                    BlockEvent.BreakEvent event2 = new BlockEvent.BreakEvent(world, p, state, player);
                    NeoForge.EVENT_BUS.post((Event)event2);
                }
            }
        }
        return false;
    }

    public static boolean unchangableBlock(Block b) {
        return EffectUtil.unchangableBlock(b, List.of());
    }

    public static boolean unchangableBlock(Block b, List<Block> extra) {
        Block[] bs = new Block[]{Blocks.END_GATEWAY, Blocks.BEDROCK, Blocks.END_PORTAL, Blocks.END_PORTAL_FRAME};
        HashSet<Block> set = new HashSet<Block>(extra);
        set.addAll(Arrays.asList(bs));
        return set.contains(b);
    }

    public static Holder<Enchantment> toHolder(ResourceKey<Enchantment> r, Level level) {
        return ((Registry)level.registryAccess().registry(Registries.ENCHANTMENT).get()).getHolderOrThrow(r);
    }

    public static int getEnchantmentLevel(ItemStack s, Holder<Enchantment> e) {
        return EnchantmentHelper.getItemEnchantmentLevel(e, (ItemStack)s);
    }

    public static boolean hasEnchantment(ItemStack s, Holder<Enchantment> e) {
        return EffectUtil.getEnchantmentLevel(s, e) > 0;
    }

    public static void addEnchantment(ItemStack s, Holder<Enchantment> e, int value) {
        s.enchant(e, value);
    }

    public static boolean hasEnchantment(ItemStack s, ResourceKey<Enchantment> e, Level level) {
        return EffectUtil.hasEnchantment(s, EffectUtil.toHolder(e, level));
    }

    public static void addEnchantment(ItemStack s, ResourceKey<Enchantment> e, int value, Level level) {
        EffectUtil.addEnchantment(s, EffectUtil.toHolder(e, level), value);
    }

    public static Vec3 fromBlockPos(BlockPos pos) {
        return new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static ServerLevel getNewDimensionByName(ServerLevel world, ResourceLocation key) {
        return world.getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)key));
    }

    public static ResourceLocation getDimension(Level w) {
        return w.dimension().location();
    }

    public static ResourceLocation getOverworld() {
        return Level.OVERWORLD.location();
    }

    public static boolean compareDimensions(ResourceLocation r1, ResourceLocation r2) {
        return r1.equals((Object)r2);
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float rad) {
        return rad * 57.29578f;
    }

    public static boolean inEntityBlacklist(Entity e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && e.getType() != null && Utils.getRegistryKey(e, e.level()) != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = Utils.getRegistryName(e);
            ret = set.contains(s) || set.contains(Utils.getRegistryKey(e, e.level()).getNamespace());
        }
        return ret;
    }

    public static boolean inGenericBlacklist(String e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && z != null && z.size() > 0) {
            String s = e;
            HashSet<? extends String> set = new HashSet<String>(z);
            ret = set.contains(s);
        }
        return ret;
    }

    public static boolean inItemBlacklist(Item e, List<? extends String> z, Level level) {
        boolean ret = false;
        HashSet<? extends String> set = new HashSet<String>(z);
        if (e != null && Utils.getRegistryName(e, level) != null && z != null && z.size() > 0) {
            String s = Utils.getRegistryName(e, level);
            ret = set.contains(s) || set.contains(Utils.getRegistryKey(e, level).getNamespace());
        }
        return ret;
    }

    public static boolean inEnchantBlacklist(Holder<Enchantment> e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && Utils.holderToKey(e) != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = Utils.holderToName(e);
            ret = set.contains(s) || set.contains(Utils.holderToKey(e).getNamespace());
        }
        return ret;
    }

    public static boolean inBlockBlacklist(Block b, List<? extends String> z, Level level) {
        boolean ret = false;
        if (b != null && z != null && !z.isEmpty()) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = Utils.getRegistryName(b, level);
            ret = set.contains(s) || set.contains(Utils.getRegistryKey(b, level).getNamespace());
        }
        return ret;
    }

    public static void magicAttack(LivingEntity living, float d, LivingEntity caster) {
        EffectUtil.genericAttack(living, d, living.damageSources().magic(), caster);
    }

    public static void genericAttack(LivingEntity living, float d, DamageSource source, LivingEntity caster) {
        if (caster instanceof Player) {
            living.setLastHurtByPlayer((Player)caster);
        }
        living.lastHurtByPlayerTime = 100;
        living.hurt(source, d);
    }

    @FunctionalInterface
    public static interface ExplodeFunction<T, U, V, W, X> {
        public X apply(T var1, U var2, V var3, W var4);
    }
}

