/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.shader.ModShaders;
import stepsword.mahoutsukai.render.tile.MahouRenderRL;
import stepsword.mahoutsukai.util.Utils;

public class ParticleFog
extends Particle {
    public ResourceLocation loc;
    public float[] rgba = new float[4];
    public float softness = 0.07f;
    public float rotation = 0.0f;
    public float sz = 8.0f;
    public boolean startmoving = false;
    public boolean shaders = true;
    public boolean agecolor = true;

    public ParticleFog(ClientLevel worldIn, ResourceLocation loc, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double motionX, double motionY, double motionZ) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        float color;
        this.gCol = 0.7137255f;
        this.rCol = 1.0f;
        this.bCol = 0.75686276f;
        float maxAge = 180.0f;
        this.lifetime = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.lifetime = (int)((float)this.lifetime * scale);
        Random random = Utils.getRandom((Level)worldIn);
        this.oRoll = this.roll = (float)random.nextInt(360) * 0.0174533f;
        this.loc = loc;
        this.softness += 0.0f;
        this.rgba[0] = color = 0.8f + 0.2f * random.nextFloat();
        this.rgba[1] = color;
        this.rgba[2] = color;
        this.rgba[3] = 0.0f;
        this.rotation = random.nextFloat() * 360.0f;
        this.sz += random.nextFloat() * 12.0f - 2.0f;
        this.sz *= 1.3f;
        motionX = random.nextFloat() * 2.0E-4f - 1.0E-4f;
        motionZ = random.nextFloat() * 2.0E-4f - 1.0E-4f;
    }

    public ParticleFog(ClientLevel worldIn, ResourceLocation loc, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double motionX, double motionY, double motionZ, boolean shaders, float r, float g, float b, float a, float thickness, float size) {
        this(worldIn, loc, xCoordIn, yCoordIn, zCoordIn, scale, motionX, motionY, motionZ);
        this.shaders = shaders;
        this.xd = motionX;
        this.yd = motionY;
        this.zd = motionZ;
        this.rgba = new float[]{r, g, b, a};
        this.startmoving = true;
        this.softness = thickness;
        this.sz = size;
        this.agecolor = false;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.NO_RENDER;
    }

    public void render(VertexConsumer builder, Camera activeRenderInfo, float partial) {
    }

    public double getDistance(double x1, double y1, double z1) {
        return (x1 - this.x) * (x1 - this.x) + (y1 - this.y) * (y1 - this.y) + (z1 - this.z) * (z1 - this.z);
    }

    public void tick() {
        ++this.age;
        Random random = Utils.getRandom((Level)this.level);
        if ((double)random.nextFloat() < 0.001 || !this.startmoving) {
            this.xd = random.nextFloat() * 0.01f - 0.005f;
            this.zd = random.nextFloat() * 0.01f - 0.005f;
            this.startmoving = true;
        }
        if (this.agecolor) {
            this.yd = 0.0;
        }
        if (this.startmoving) {
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.x += this.xd;
            this.y += this.yd;
            this.z += this.zd;
        }
        if (this.agecolor) {
            this.rgba[3] = this.age < 40 ? (float)this.age / 40.0f * 0.5f : (this.age > 730 ? (float)(800 - this.age) / 70.0f * 0.5f : 0.5f);
        }
        if (this.age > 800) {
            this.remove();
        }
    }

    public static void renderFog(ParticleFog particle, double d3, double d4, double d5, PoseStack matrix, float partialTicks) {
        RenderType fog;
        double d0 = particle.xo + (particle.x - particle.xo) * (double)partialTicks;
        double d1 = particle.yo + (particle.y - particle.yo) * (double)partialTicks;
        double d2 = particle.zo + (particle.z - particle.zo) * (double)partialTicks;
        matrix.pushPose();
        matrix.translate(d0 - d3, d1 - d4, d2 - d5);
        RenderUtils.billboard(matrix, particle.rotation, partialTicks);
        matrix.scale(particle.sz, particle.sz, particle.sz);
        float r = particle.rgba[0];
        float g = particle.rgba[1];
        float b = particle.rgba[2];
        float a = particle.rgba[3];
        int j = 240;
        int k = 240;
        float xx = 0.5f;
        float bxx = -xx;
        float yy = 0.0f;
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        Matrix4f m = matrix.last().pose();
        if (!MTConfig.NO_SHADERS && !RenderUtils.turnOffMahouShaders() && ModShaders.FOGGY_QUADS != null) {
            ModShaders.FOGGY_QUADS.smoke(0.07f);
            float nearf = (float)(particle.getPos().subtract(Minecraft.getInstance().player.position()).length() / 10.0);
            ModShaders.FOGGY_QUADS.color(particle.rgba[0], particle.rgba[1], particle.rgba[2], particle.rgba[3] * nearf);
            ModShaders.FOGGY_QUADS.nearfar(0.07f, 400.0f);
            if (ModShaders.FOGGY_QUADS.MODEL_VIEW_MATRIX != null) {
                ModShaders.FOGGY_QUADS.MODEL_VIEW_MATRIX.set(m);
            }
            if (ModShaders.FOGGY_QUADS.PROJECTION_MATRIX != null) {
                ModShaders.FOGGY_QUADS.PROJECTION_MATRIX.set(RenderSystem.getProjectionMatrix());
            }
            fog = MahoujinRenderType.wrapFogLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createFogRenderType(MahouRenderRL.fog, 0, true, () -> ModShaders.FOGGY_QUADS)), particle.rgba, particle.softness);
        } else {
            RenderSystem.enableBlend();
            RenderSystem.depthFunc((int)513);
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((int)770, (int)771);
            fog = MahoujinRenderType.wrapFogLayer(MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(MahouRenderRL.fog, 0, false)), particle.rgba, particle.softness);
        }
        VertexConsumer bb = buf.getBuffer(fog);
        bb.addVertex(m, bxx, yy, bxx).setColor(r, g, b, a).setUv(0.0f, 0.0f).setUv2(j, k);
        bb.addVertex(m, bxx, yy, xx).setColor(r, g, b, a).setUv(0.0f, 1.0f).setUv2(j, k);
        bb.addVertex(m, xx, yy, xx).setColor(r, g, b, a).setUv(1.0f, 1.0f).setUv2(j, k);
        bb.addVertex(m, xx, yy, bxx).setColor(r, g, b, a).setUv(1.0f, 0.0f).setUv2(j, k);
        buf.endBatch(fog);
        matrix.popPose();
    }
}

