/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.Leylines;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderLeyLines {
    public static int indexcounter = 0;

    public static void leyRender(Entity e, PoseStack matrix, float partialTicks) {
        if (!Leylines.leyDimensionValid(EffectUtil.getDimension(e.level()))) {
            return;
        }
        if (e instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)e, ModEffects.FAY_SIGHT_EYES)) {
            int renderdist = MTConfig.LEY_RENDER_DISTANCE;
            int renderheight = MTConfig.LEY_RENDER_HEIGHT;
            BlockPos epos = e.blockPosition();
            int startx = epos.getX() - renderdist;
            int endx = epos.getX() + renderdist;
            int startz = epos.getZ() - renderdist;
            int endz = epos.getZ() + renderdist;
            indexcounter = 0;
            for (int i = startx; i < endx; ++i) {
                for (int j = startz; j < endz; ++j) {
                    BlockPos bp = new BlockPos(i, renderheight, j);
                    Leylines.LeyLineShape shape = Leylines.leyOrientation(bp);
                    if (shape == Leylines.LeyLineShape.NONE) continue;
                    boolean h = shape == Leylines.LeyLineShape.HORIZ || shape == Leylines.LeyLineShape.STAR;
                    boolean v = shape == Leylines.LeyLineShape.VERT || shape == Leylines.LeyLineShape.STAR;
                    boolean ne = shape == Leylines.LeyLineShape.NED || shape == Leylines.LeyLineShape.CROSS || shape == Leylines.LeyLineShape.STAR;
                    boolean nw = shape == Leylines.LeyLineShape.NWD || shape == Leylines.LeyLineShape.CROSS || shape == Leylines.LeyLineShape.STAR;
                    RenderLeyLines.doRender(matrix, i, MTConfig.LEY_RENDER_HEIGHT, j, partialTicks, h, v, ne, nw);
                }
            }
        }
    }

    public static void doRender(PoseStack matrix, double x, double y, double z, float partialTicks, boolean rh, boolean rv, boolean rne, boolean rnw) {
        boolean runes = MTConfig.LEY_RUNES;
        Entity entity = Minecraft.getInstance().getCameraEntity();
        Camera renderInfo = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 proj = renderInfo.getPosition();
        double d0 = proj.x;
        double d1 = proj.y;
        double d2 = proj.z;
        float r = 0.65882355f;
        float g = 1.0f;
        float b = 0.21176471f;
        float a = 1.0f;
        float center = 0.5f;
        matrix.pushPose();
        RenderLeyLines.runes(matrix, Minecraft.getInstance().renderBuffers().bufferSource(), x, y, z, d0 -= (double)center, d1 -= (double)center, d2 -= (double)center, rh, rv, rne, rnw, r, g, b, a, partialTicks);
        matrix.popPose();
    }

    public static void runes(PoseStack matrix, MultiBufferSource.BufferSource buffer, double x, double y, double z, double d0, double d1, double d2, boolean rh, boolean rv, boolean rne, boolean rnw, float r, float g, float b, float a, float pt) {
        VertexConsumer bb;
        RenderType type;
        Matrix4f m = matrix.last().pose();
        float f = 0.15f;
        int lx = 240;
        int ly = 240;
        float minu = 0.0f;
        float maxu = 0.3f;
        float minv = 0.0f;
        float maxv = 1.0f;
        if (rh) {
            type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(RenderUtils.runes, indexcounter, false));
            bb = buffer.getBuffer(type);
            bb.addVertex(m, (float)x - (float)d0, (float)y - (float)d1, (float)z - (float)d2 - f).setColor(r, g, b, a).setUv(minu, minv).setUv2(lx, ly);
            bb.addVertex(m, (float)x - (float)d0, (float)y - (float)d1, (float)z - (float)d2 + f).setColor(r, g, b, a).setUv(minu, maxv).setUv2(lx, ly);
            bb.addVertex(m, (float)x + 1.0f - (float)d0, (float)y - (float)d1, (float)z - (float)d2 + f).setColor(r, g, b, a).setUv(maxu, maxv).setUv2(lx, ly);
            bb.addVertex(m, (float)x + 1.0f - (float)d0, (float)y - (float)d1, (float)z - (float)d2 - f).setColor(r, g, b, a).setUv(maxu, minv).setUv2(lx, ly);
            buffer.endBatch(type);
        }
        if (rv) {
            type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(RenderUtils.runes, indexcounter, false));
            bb = buffer.getBuffer(type);
            bb.addVertex(m, (float)x - (float)d0 + f, (float)y - (float)d1, (float)z - (float)d2).setColor(r, g, b, a).setUv(minu, minv).setUv2(lx, ly);
            bb.addVertex(m, (float)x - (float)d0 - f, (float)y - (float)d1, (float)z - (float)d2).setColor(r, g, b, a).setUv(minu, maxv).setUv2(lx, ly);
            bb.addVertex(m, (float)x - (float)d0 - f, (float)y - (float)d1, (float)z + 1.0f - (float)d2).setColor(r, g, b, a).setUv(maxu, maxv).setUv2(lx, ly);
            bb.addVertex(m, (float)x - (float)d0 + f, (float)y - (float)d1, (float)z + 1.0f - (float)d2).setColor(r, g, b, a).setUv(maxu, minv).setUv2(lx, ly);
            buffer.endBatch(type);
        }
        if (rne) {
            type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(RenderUtils.runes, indexcounter, false));
            bb = buffer.getBuffer(type);
            bb.addVertex(m, (float)x + 1.0f - (float)d0 - f - 0.5f, (float)y - (float)d1, (float)z - (float)d2 - f - 0.5f).setColor(r, g, b, a).setUv(minu, minv).setUv2(lx, ly);
            bb.addVertex(m, (float)x + 1.0f - (float)d0 + f - 0.5f, (float)y - (float)d1, (float)z - (float)d2 + f - 0.5f).setColor(r, g, b, a).setUv(minu, maxv).setUv2(lx, ly);
            bb.addVertex(m, (float)x - (float)d0 + f - 0.5f, (float)y - (float)d1, (float)z - (float)d2 + 1.0f + f - 0.5f).setColor(r, g, b, a).setUv(maxu, maxv).setUv2(lx, ly);
            bb.addVertex(m, (float)x - (float)d0 - f - 0.5f, (float)y - (float)d1, (float)z - (float)d2 + 1.0f - f - 0.5f).setColor(r, g, b, a).setUv(maxu, minv).setUv2(lx, ly);
            buffer.endBatch(type);
        }
        if (rnw) {
            type = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createMahoujinRenderType(RenderUtils.runes, indexcounter, false));
            bb = buffer.getBuffer(type);
            bb.addVertex(m, (float)x - (float)d0 + f, (float)y - (float)d1, (float)z - (float)d2 - f).setColor(r, g, b, a).setUv(minu, minv).setUv2(lx, ly);
            bb.addVertex(m, (float)x - (float)d0 - f, (float)y - (float)d1, (float)z - (float)d2 + f).setColor(r, g, b, a).setUv(minu, maxv).setUv2(lx, ly);
            bb.addVertex(m, (float)x + 1.0f - (float)d0 - f, (float)y - (float)d1, (float)z - (float)d2 + 1.0f + f).setColor(r, g, b, a).setUv(maxu, maxv).setUv2(lx, ly);
            bb.addVertex(m, (float)x + 1.0f - (float)d0 + f, (float)y - (float)d1, (float)z - (float)d2 + 1.0f - f).setColor(r, g, b, a).setUv(maxu, minv).setUv2(lx, ly);
            buffer.endBatch(type);
        }
        if (rnw && rne) {
            matrix.translate(x - d0, y - d1, z - d2);
            float rotation = ClientHandler.clientTickCounter % 360L;
            rotation = rotation - 1.0f + pt;
            RenderUtils.rotateQ(rotation, 0.0f, 1.0f, 0.0f, matrix);
            RenderType ringType = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesPRenderType(RenderUtils.runes, indexcounter));
            RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, -0.1, 0.0f, 3.0f, 0.3f, 64, lx, ly, r, g, b, a, ringType);
            RenderUtils.rotateQ(-rotation, 0.0f, 1.0f, 0.0f, matrix);
            buffer.endBatch(ringType);
            RenderUtils.rotateQ(-rotation, 0.0f, 1.0f, 0.0f, matrix);
            ringType = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesPRenderType(RenderUtils.runes, indexcounter));
            RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, -0.1, 0.0f, 5.0f, 0.3f, 64, lx, ly, r, g, b, a, ringType);
            RenderUtils.rotateQ(rotation, 0.0f, 1.0f, 0.0f, matrix);
            buffer.endBatch(ringType);
            if (rv && rh) {
                RenderUtils.rotateQ(rotation, 0.0f, 1.0f, 0.0f, matrix);
                ringType = MahoujinRenderType.wrapCullLayer(MahoujinRenderType.createRunesPRenderType(RenderUtils.runes, indexcounter));
                RenderUtils.renderRing(matrix, (MultiBufferSource)buffer, -0.1, 0.0f, 7.0f, 0.3f, 64, lx, ly, r, g, b, a, ringType);
                RenderUtils.rotateQ(-rotation, 0.0f, 1.0f, 0.0f, matrix);
                buffer.endBatch(ringType);
            }
            matrix.translate(-x + d0, -y + d1, -z + d2);
        }
    }
}

