/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.mana;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.antlr.v4.runtime.misc.MultiMap;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.util.Utils;

public class ActiveCircleConfig {
    public static HashMap<String, Integer> limitationMap = null;
    public static HashMap<UUID, MultiMap<String, ActiveMahoujin>> currentActiveMap = null;

    public static boolean tryToOperate(@Nonnull BlockEntity be, @Nonnull UUID casterUUID) {
        if (!ActiveCircleConfig.isLimited()) {
            return true;
        }
        ActiveCircleConfig.buildLimitationMap();
        String name = Utils.getRegistryName(be.getBlockState().getBlock(), be.getLevel());
        if (limitationMap.containsKey(name)) {
            List<ActiveMahoujin> activeCircles;
            MultiMap<String, ActiveMahoujin> castermap;
            if (currentActiveMap == null) {
                currentActiveMap = new HashMap();
            }
            if (currentActiveMap.containsKey(casterUUID)) {
                castermap = currentActiveMap.get(casterUUID);
            } else {
                castermap = new MultiMap<String, ActiveMahoujin>();
                currentActiveMap.put(casterUUID, castermap);
            }
            if (castermap.containsKey((Object)name)) {
                activeCircles = (List)castermap.get((Object)name);
            } else {
                activeCircles = new ArrayList();
                castermap.put((Object)name, activeCircles);
            }
            boolean found = false;
            long now = be.getLevel().getGameTime();
            int TICKS_TO_BE_REPLACED = MTConfig.ACTIVE_MAGIC_CIRCLE_REPLACEMENT_TIME;
            long oldest = Long.MAX_VALUE;
            ActiveMahoujin oldestMahoujin = null;
            for (ActiveMahoujin active : activeCircles) {
                if (active.pos.equals((Object)be.getBlockPos())) {
                    active.lastActive = now;
                    found = true;
                }
                if (active.lastActive >= oldest) continue;
                oldest = active.lastActive;
                oldestMahoujin = active;
            }
            if (!found) {
                ActiveMahoujin active;
                if (activeCircles.size() < limitationMap.get(name)) {
                    active = new ActiveMahoujin();
                    active.pos = be.getBlockPos();
                    active.lastActive = now;
                    activeCircles.add(active);
                    return true;
                }
                if (oldestMahoujin != null) {
                    if ((long)TICKS_TO_BE_REPLACED < now - oldestMahoujin.lastActive) {
                        activeCircles.remove(oldestMahoujin);
                    }
                    if (activeCircles.size() < limitationMap.get(name)) {
                        active = new ActiveMahoujin();
                        active.pos = be.getBlockPos();
                        active.lastActive = now;
                        activeCircles.add(active);
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public static boolean isLimited() {
        return !MTConfig.ACTIVE_MAGIC_CIRCLE_LIMITS.isEmpty() && !MTConfig.ACTIVE_MAGIC_CIRCLE_NAMES.isEmpty();
    }

    public static void buildLimitationMap() {
        if (limitationMap == null || limitationMap.size() != MTConfig.ACTIVE_MAGIC_CIRCLE_NAMES.size()) {
            int top = Math.min(MTConfig.ACTIVE_MAGIC_CIRCLE_LIMITS.size(), MTConfig.ACTIVE_MAGIC_CIRCLE_NAMES.size());
            limitationMap = new HashMap();
            for (int m = 0; m < top; ++m) {
                limitationMap.put(MTConfig.ACTIVE_MAGIC_CIRCLE_NAMES.get(m), MTConfig.ACTIVE_MAGIC_CIRCLE_LIMITS.get(m));
            }
        }
    }

    public static class ActiveMahoujin {
        public BlockPos pos = null;
        public long lastActive = -1L;
    }
}

