/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.nobu;

import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import stepsword.mahoutsukai.advancements.MahouTrigger;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dataattachments.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.datacomponents.selectedtarget.SelectedTargetMahou;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.entity.mahoujin.GunEntity;
import stepsword.mahoutsukai.item.EmptyProjectileWeaponItem;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.PlayerHelp;
import stepsword.mahoutsukai.util.Utils;

public class Nobu
extends EmptyProjectileWeaponItem {
    public static ConcurrentHashMap<UUID, NobuUserStorage> player_storage = new ConcurrentHashMap();

    public Nobu() {
        super(new Item.Properties().stacksTo(1).durability(MTConfig.NOBU_DURABILITY));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public static void clearNobuStorage(Player player) {
        if (player_storage.containsKey(player.getUUID())) {
            NobuUserStorage storage = player_storage.get(player.getUUID());
            for (Integer e : storage.guns.keySet()) {
                GunEntity g = storage.guns.get(e);
                if (g == null) continue;
                g.discard();
            }
            storage.fireMe = 0;
            storage.isFiring = false;
            storage.currentGun = 0;
            storage.origpit = 0.0f;
            storage.origyaw = 0.0f;
            storage.originalBasis2 = null;
            storage.originalBasis = null;
            storage.guns = new HashMap();
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack itemstack = player.getItemInHand(handIn);
        int mode = Utils.getMode(itemstack);
        NobuUserStorage storage = Nobu.getStorage(player);
        if (!player.isDiscrete()) {
            player.startUsingItem(handIn);
        } else {
            if (!worldIn.isClientSide) {
                List<Integer> settings = MahouSettings.getIntSettings(player, MahouSettings.Spell.NOBU);
                Utils.color(itemstack, settings.get(0).intValue(), settings.get(1).intValue(), settings.get(2).intValue(), settings.get(3).intValue(), settings.get(4).intValue(), settings.get(5).intValue());
                storage.lastMode = mode;
                Utils.setMode(itemstack, (storage.lastMode + 1) % 4);
                mode = Utils.getMode(itemstack);
            }
            MutableComponent tt = mode == 0 ? Component.translatable((String)"mahoutsukai.nobu.auto") : (mode == 1 ? Component.translatable((String)"mahoutsukai.nobu.targetsummon") : (mode == 2 ? Component.translatable((String)"mahoutsukai.nobu.firingsquadcircle") : Component.translatable((String)"mahoutsukai.nobu.firingsquadline")));
            player.displayClientMessage((Component)tt, true);
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }

    public boolean isEnchantable(ItemStack pStack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean isPrimaryItemFor(ItemStack stack, Holder<Enchantment> enchantment) {
        if (stack.getItem() instanceof Nobu) {
            return enchantment.is(Enchantments.POWER) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.MENDING);
        }
        return false;
    }

    public static void nobuCreate(LivingIncomingDamageEvent event) {
        Player p;
        double NOBU_DISTANCE_REQUIREMENT = MTConfig.NOBU_DISTANCE_REQUIREMENT;
        Entity cause = event.getSource().getEntity();
        Entity projectile = event.getSource().getDirectEntity();
        if (MTConfig.NOBU_ENABLED && projectile instanceof Projectile && cause instanceof Player && Nobu.validNobuItem((p = (Player)cause).getMainHandItem(), p.level()) && StrengtheningSpellEffect.getStrengthened(p.getMainHandItem()) > 0) {
            if (p.position().subtract(projectile.position()).length() > NOBU_DISTANCE_REQUIREMENT) {
                p.getInventory().removeItemNoUpdate(p.getInventory().selected);
                ItemStack change = new ItemStack((ItemLike)ModItems.nobu.get());
                if (MTConfig.NOBU_IS_UNBREAKABLE) {
                    change.set(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true));
                }
                if (!p.getInventory().add(p.getInventory().selected, change)) {
                    p.drop(change, false);
                }
                ((MahouTrigger)((Object)ModTriggers.NOBU.get())).trigger((ServerPlayer)p);
            } else {
                PlayerHelp.sendHelpMessage(p, PlayerHelp.Message.NOBU_FURTHER_AWAY);
            }
        }
    }

    public static boolean validNobuItem(ItemStack s, Level level) {
        return EffectUtil.inItemBlacklist(s.getItem(), MTConfig.NOBU_ALLOWED_BOWS, level);
    }

    public void onUseTick(Level level, LivingEntity living, ItemStack stack, int count) {
        if (!level.isClientSide) {
            int MAX_GUNS = MTConfig.NOBU_MAX_GUNS;
            if (living instanceof Player) {
                Player player = (Player)living;
                int mode = Utils.getMode(stack);
                NobuUserStorage storage = Nobu.getStorage(player);
                if (mode != 0 && mode != storage.lastMode && count == 72000) {
                    Nobu.clearNobuStorage(player);
                    storage.lastMode = mode;
                }
                if (!(mode != 1 && mode != 2 && mode != 3 || count % MTConfig.NOBU_SPAWN_AND_FIRE_FREQ != 0 || storage.target == null && mode != 3)) {
                    if (storage.isFiring) {
                        if (mode == 1) {
                            Nobu.fireRotation(storage);
                        }
                    } else if (mode == 3) {
                        GunEntity ge;
                        if (!(storage.guns.size() >= MAX_GUNS || (ge = this.spawnGun(player, mode, null, storage.currentGun, MAX_GUNS, storage)) == null || storage.guns.containsKey(storage.currentGun) && storage.guns.get(storage.currentGun).isAlive())) {
                            storage.guns.put(storage.currentGun, ge);
                            ++storage.currentGun;
                            storage.currentGun %= MAX_GUNS;
                        }
                    } else {
                        storage.target.ifLeft(e -> {
                            if (storage.guns.size() < MAX_GUNS) {
                                GunEntity ge;
                                if (!(storage.guns.containsKey(storage.currentGun) && storage.guns.get(storage.currentGun).isAlive() || (ge = this.spawnGun(player, mode, (Entity)e, storage.currentGun, MAX_GUNS, storage)) == null)) {
                                    storage.guns.put(storage.currentGun, ge);
                                }
                                ++storage.currentGun;
                                storage.currentGun %= MAX_GUNS;
                            }
                        });
                    }
                }
            }
        }
    }

    public static void nobuPlayerTick(PlayerTickEvent.Post event) {
        if (player_storage.containsKey(event.getEntity().getUUID())) {
            NobuUserStorage storage = Nobu.getStorage(event.getEntity());
            Nobu.fireRotation(storage);
        }
    }

    public static void fireRotation(NobuUserStorage storage) {
        if (storage != null && storage.isFiring) {
            if (storage.fireMe >= 0 && storage.fireMe < storage.guns.size()) {
                GunEntity ge = new ArrayList<GunEntity>(storage.guns.values()).get(storage.fireMe);
                if (ge != null && ge.isAlive()) {
                    ge.fireBeam();
                }
                ++storage.fireMe;
            } else {
                storage.fireMe = 0;
                storage.isFiring = false;
            }
        }
    }

    public void gunSound(NobuUserStorage storage, GunEntity ge, int current, int max) {
        ge.sound = current == max - 1 ? 3 : storage.currentSound;
        if (storage.currentSound == 2) {
            storage.soundup = false;
        }
        if (storage.currentSound == 0) {
            storage.soundup = true;
        }
        if (storage.currentSound < 2 && storage.soundup) {
            ++storage.currentSound;
        } else if (storage.currentSound > 0 && !storage.soundup) {
            --storage.currentSound;
        }
    }

    public GunEntity spawnGun(Player player, int mode, Entity target, int current, int max, NobuUserStorage storage) {
        double distance = MTConfig.NOBU_CIRCLE_RADIUS;
        float[] colors = Nobu.getColor(player, mode);
        if (mode == 1 || mode == 2) {
            float angle = (float)((double)(current * 2) * Math.PI / (double)max);
            if (current == 0) {
                storage.originalBasis = target.position();
            }
            Vec3 circle_place = new Vec3(1.0, 0.0, 0.0).yRot(angle).normalize().scale(distance);
            float height = this.getHeightRelativeToEntity(target);
            Vec3 spawn = storage.originalBasis.add(0.0, (double)height, 0.0).add(circle_place);
            if (this.canSpawn(player.level(), spawn) && Nobu.doSummonMana(player)) {
                GunEntity ge = new GunEntity(player.level(), player, colors[0], colors[1], colors[2], 1.0f, colors[3], colors[4], colors[5], 1.0f);
                ge.setPos(spawn);
                ge.setCircleSize(7.0f);
                ge.aimAt(storage.originalBasis);
                if (mode == 1) {
                    ge.autonomous = false;
                    ge.setTarget(target.getId());
                } else {
                    ge.autonomous = true;
                }
                this.gunSound(storage, ge, current, max);
                player.level().addFreshEntity((Entity)ge);
                return ge;
            }
        } else if (mode == 3) {
            if (current == 0 && (storage.originalBasis == null || storage.originalBasis2 == null)) {
                storage.originalBasis = player.calculateViewVector(player.xRot, player.yHeadRot).normalize();
                storage.originalBasis2 = player.position();
                storage.origyaw = player.yHeadRot;
                storage.origpit = player.xRot;
            }
            double loc = -MTConfig.NOBU_FIRING_LINE_SPACE / 2.0 + MTConfig.NOBU_FIRING_LINE_SPACE / (double)max * (double)current;
            double height = MTConfig.NOBU_MAX_SPAWN_HEIGHT;
            Vec3 playerLook = storage.originalBasis;
            playerLook = new Vec3(playerLook.x, 0.0, playerLook.z);
            Vec3 spawn = storage.originalBasis2.add(playerLook.scale((double)height).x, height, playerLook.scale((double)height).z);
            Vec3 sideways = playerLook.normalize().yRot(org.joml.Math.toRadians((float)90.0f));
            spawn = spawn.add(sideways.scale(loc));
            if (this.canSpawn(player.level(), spawn) && Nobu.doSummonMana(player)) {
                GunEntity ge = new GunEntity(player.level(), player, colors[0], colors[1], colors[2], 1.0f, colors[3], colors[4], colors[5], 1.0f);
                ge.setPos(spawn);
                ge.setCircleSize(7.0f);
                ge.setRotationYaw(-storage.origyaw + 180.0f);
                ge.setRotationPitch(storage.origpit);
                ge.setRotationRoll(90.0f);
                ge.autonomous = true;
                this.gunSound(storage, ge, current, max);
                player.level().addFreshEntity((Entity)ge);
                return ge;
            }
        }
        return null;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        return super.onEntityItemUpdate(stack, entity);
    }

    public float getHeightRelativeToEntity(Entity target) {
        Vec3 p = target.position();
        int countup = 0;
        int countdown = 0;
        BlockPos above = Utils.toBlockPos(p.add(0.0, (double)target.getBbHeight(), 0.0));
        BlockPos below = Utils.toBlockPos(p);
        int i = 0;
        while ((double)i < MTConfig.NOBU_MAX_SPAWN_HEIGHT * 2.0) {
            above = above.above();
            below = below.below();
            if (!target.level().getBlockState(above).isAir()) {
                ++countdown;
            }
            if (!target.level().getBlockState(below).isAir()) {
                ++countdown;
            }
            ++i;
        }
        return (float)(-MTConfig.NOBU_MAX_SPAWN_HEIGHT + (double)(Math.abs(countdown - countup) * 1));
    }

    public boolean canSpawn(Level level, Vec3 propose) {
        return level.getBlockState(Utils.toBlockPos(propose)).isAir();
    }

    public static NobuUserStorage getStorage(Player player) {
        NobuUserStorage storage;
        if (player_storage.containsKey(player.getUUID())) {
            storage = player_storage.get(player.getUUID());
        } else {
            storage = new NobuUserStorage();
            player_storage.put(player.getUUID(), storage);
        }
        return storage;
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeCharged) {
        Nobu.clearTarget(pStack, pLivingEntity);
    }

    public static void clearTarget(ItemStack stack, LivingEntity living) {
        Player player;
        if (stack.getItem() instanceof Nobu && living instanceof Player) {
            player = (Player)living;
            Nobu.setSelectedTarget(stack, -1);
            NobuUserStorage storage = player_storage.get(player.getUUID());
            storage.target = null;
        }
        if (Utils.getMode(stack) == 1 && living instanceof Player) {
            player = (Player)living;
            Nobu.clearNobuStorage(player);
        }
    }

    public static boolean doSummonMana(Player player) {
        boolean ret;
        boolean bl = ret = PlayerManaManager.drainMana(player, Nobu.getManaPerConstruct(), false, false) == Nobu.getManaPerConstruct();
        if (ret && player.getMainHandItem().getItem() instanceof Nobu) {
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        return ret;
    }

    public static boolean doShotMana(Player player) {
        boolean ret;
        boolean bl = ret = PlayerManaManager.drainMana(player, Nobu.getManaPerShot(), false, false) == Nobu.getManaPerShot();
        if (ret && player.getMainHandItem().getItem() instanceof Nobu) {
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        return ret;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.NOBU_DURABILITY;
    }

    public static int getManaPerShot() {
        return MTConfig.NOBU_MANA_PER_SHOT;
    }

    public static int getManaPerConstruct() {
        return MTConfig.NOBU_MANA_PER_CONSTRUCT;
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        Nobu.clearTarget(pStack, pLivingEntity);
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    public static float[] getColor(Player caster, int mode) {
        float[] ret = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        MahouSettings.Spell spell = MahouSettings.Spell.NOBU;
        List<Integer> settings = MahouSettings.getIntSettings(caster, spell);
        ret[0] = (float)settings.get(0).intValue() / 255.0f;
        ret[1] = (float)settings.get(1).intValue() / 255.0f;
        ret[2] = (float)settings.get(2).intValue() / 255.0f;
        ret[3] = (float)settings.get(3).intValue() / 255.0f;
        ret[4] = (float)settings.get(4).intValue() / 255.0f;
        ret[5] = (float)settings.get(5).intValue() / 255.0f;
        return ret;
    }

    public static int getSelectedTarget(ItemStack stack) {
        SelectedTargetMahou mahou = Utils.getSelectedTarget(stack);
        return mahou.getTargetId();
    }

    public static void setSelectedTarget(ItemStack stack, int t) {
        SelectedTargetMahou mahou = Utils.getSelectedTarget(stack);
        mahou.setTargetId(t);
        Utils.setSelectedTarget(stack, mahou);
    }

    public static class NobuUserStorage {
        public HashMap<Integer, GunEntity> guns = new HashMap();
        public Either<Entity, BlockPos> target = null;
        public int currentGun = 0;
        public boolean isFiring = false;
        public int fireMe = 0;
        public int lastMode = 0;
        public Vec3 originalBasis = null;
        public Vec3 originalBasis2 = null;
        public float origyaw = 0.0f;
        public float origpit = 0.0f;
        public int currentSound = 0;
        public boolean soundup = true;
    }
}

