/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.attunedgems;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.dataattachments.mahou.IMahou;
import stepsword.mahoutsukai.datacomponents.DataComponents;
import stepsword.mahoutsukai.datacomponents.gemmahou.GemMahou;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.util.Utils;

public class AttunedGem
extends ItemBase {
    private int MAX_MANA;

    public AttunedGem(String gem, int maxMana) {
        super(new Item.Properties().component(DataComponents.GEM_COMPONENT, (Object)new GemMahou(0)), 1);
        this.MAX_MANA = maxMana;
    }

    public boolean isBarVisible(ItemStack itemStack) {
        return true;
    }

    public int getBarWidth(ItemStack itemStack) {
        float zz = this.getDuraRatio(itemStack);
        return Math.round(zz * 13.0f);
    }

    public float getDuraRatio(ItemStack stack) {
        GemMahou gemMahou = Utils.getGemMahou(stack);
        float q = gemMahou != null ? (float)gemMahou.getStoredMana() : (float)this.getMaxMana();
        float zz = q / (float)this.getMaxMana();
        return zz;
    }

    public int getBarColor(ItemStack itemStack) {
        float f = Math.max(0.0f, this.getDuraRatio(itemStack));
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getMaxMana() {
        return this.MAX_MANA;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        GemMahou gemMahou;
        super.appendHoverText(stack, context, tooltip, flagIn);
        Item item = stack.getItem();
        if (item instanceof AttunedGem && Utils.getGemMahou(stack) != null && (gemMahou = Utils.getGemMahou(stack)) != null) {
            String maxMana = "" + ((AttunedGem)item).getMaxMana();
            String storedMana = "" + gemMahou.getStoredMana();
            tooltip.add((Component)Component.literal((String)(storedMana + " / " + maxMana)));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && stack.getItem() instanceof AttunedGem && !player.isDiscrete()) {
            this.charge(stack, player);
            AttunedGem.triggerUpdate((ServerPlayer)player, stack);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void charge(ItemStack itemStack, Player player) {
        IMahou playerMahou = Utils.getPlayerMahou(player);
        GemMahou gemMahou = Utils.getGemMahou(itemStack);
        int storedMana = gemMahou.getStoredMana();
        double chargeRate = playerMahou.getChargeRate();
        int playerMaxMana = playerMahou.getMaxMana();
        int manaDifference = (int)Math.ceil((double)playerMaxMana * chargeRate);
        if (storedMana < this.getMaxMana()) {
            manaDifference = Math.min(manaDifference, this.getMaxMana() - storedMana);
            manaDifference = PlayerManaManager.drainMana(player, manaDifference, true, false);
            gemMahou.setStoredMana(storedMana + manaDifference);
        }
        if ((storedMana = gemMahou.getStoredMana()) >= this.getMaxMana()) {
            gemMahou.setStoredMana(this.getMaxMana());
        }
        Utils.setGemMahou(itemStack, gemMahou);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level worldIn, LivingEntity entityLiving) {
        return stack;
    }

    public static void triggerUpdate(ServerPlayer player, ItemStack stack) {
        player.connection.send((Packet)new ClientboundSetCarriedItemPacket(player.getInventory().selected));
    }
}

