/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.mana.PlayerManaManager;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class FallenDownEntity
extends Entity {
    Player player;
    public static final String entityName = "fallen_down_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.defineId(FallenDownEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.defineId(FallenDownEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.defineId(FallenDownEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;

    public FallenDownEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public FallenDownEntity(Level world) {
        super((EntityType)ModEntities.FALLEN_DOWN.get(), world);
        this.noCulling = true;
    }

    public FallenDownEntity(Level world, LivingEntity caster) {
        this(world);
        this.setCasterUUID(caster.getUUID());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFE, (Object)0);
        builder.define(CASTER_UUID, Optional.empty());
        builder.define(FIRED, (Object)false);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setLife(compound.getInt(TAG_LIFE));
        this.setFired(compound.getBoolean(TAG_FIRED));
        if (compound.hasUUID(TAG_CASTER)) {
            this.setCasterUUID(compound.getUUID(TAG_CASTER));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt(TAG_LIFE, this.getLife());
        compound.putBoolean(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.putUUID(TAG_CASTER, this.getCasterUUID());
        }
    }

    public float getGrowingLife() {
        return 50.0f;
    }

    public void tick() {
        int radius = Math.min(this.getLife() / 20 + 1, 30);
        radius = MTConfig.FALLEN_DOWN_RADIUS;
        if (!this.level().isClientSide && ServerHandler.tickCounter % 4L == 0L) {
            ServerPlayer caster = null;
            if (this.level().getServer() != null) {
                caster = this.level().getServer().getPlayerList().getPlayer(this.getCasterUUID());
            }
            int mana = MTConfig.FALLEN_DOWN_MANA_PER_TICK;
            if (caster == null || !(caster.getUseItem().getItem() instanceof FallenDownSpellScroll) && !(caster.getUseItem().getItem() instanceof MysticCode)) {
                this.discard();
            }
            if (caster == null) {
                this.discard();
                return;
            }
            if (PlayerManaManager.drainMana((Player)caster, mana, false, false, true, false) == mana && this.getLife() > 20) {
                ((ServerLevel)this.level()).rainLevel = Math.min((float)this.getLife() / 40.0f, 4.8f);
                AABB aabb = new AABB((double)(this.blockPosition().getX() - radius), 0.0, (double)(this.blockPosition().getZ() - radius), (double)(this.blockPosition().getX() + radius), 255.0, (double)(this.blockPosition().getZ() + radius));
                List lst = this.level().getEntities((Entity)this, aabb, a -> a instanceof LivingEntity && !ContractMahoujinTileEntity.isImmuneToSpell(this.level(), this.getCasterUUID(), a) && a.onGround());
                ArrayList<BlockPos> blocksBreak = new ArrayList<BlockPos>();
                ArrayList<BlockPos> blocksFall = new ArrayList<BlockPos>();
                for (Entity e : lst) {
                    Vec3 motion = e.getDeltaMovement();
                    double motionX = motion.x();
                    double motionY = motion.y();
                    double motionZ = motion.z();
                    motionX *= 0.2;
                    motionY = motionY > 0.0 ? (motionY *= 0.2) : (motionY *= 1.7);
                    motionZ *= 0.2;
                    BlockPos ep = e.blockPosition();
                    int break_radius = 3;
                    int depth = 4;
                    for (int i = -break_radius - 1; i <= break_radius; ++i) {
                        for (int j = -break_radius - 1; j <= break_radius; ++j) {
                            BlockPos tmp;
                            int k;
                            int m = 0;
                            if (i * i + j * j >= break_radius * break_radius) continue;
                            for (k = ep.getY() - depth; k < ep.getY(); ++k) {
                                tmp = new BlockPos(ep.getX() + i, k, ep.getZ() + j);
                                if (!FallenDownEntity.okToBreak(this.level().getBlockState(tmp), this.level(), tmp)) continue;
                                if (m >= depth / 2) {
                                    blocksFall.add(tmp);
                                } else {
                                    blocksBreak.add(tmp);
                                }
                                ++m;
                            }
                            k = (int)((float)ep.getY() + e.getBbHeight());
                            while ((float)k < (float)ep.getY() + e.getBbHeight() + (float)(depth / 2)) {
                                tmp = new BlockPos(ep.getX() + i, k, ep.getZ() + j);
                                blocksFall.add(tmp);
                                ++k;
                            }
                        }
                    }
                }
                this.fallenDown(blocksBreak, (Player)caster, (ServerLevel)this.level(), "", false, false);
                this.fallenDown(blocksFall, (Player)caster, (ServerLevel)this.level(), "", false, true);
            }
        }
        this.setLife(this.getLife() + 1);
    }

    public void fallenDown(List<BlockPos> affected, Player caster, ServerLevel world, String name, boolean drop, boolean fall) {
        if (caster == null && this.player == null) {
            this.player = SafeFakePlayer.createFakePlayerIfNull(world);
        } else if (caster != null) {
            this.player = caster;
        }
        Collections.shuffle(affected);
        EffectUtil.tryFakeExplosion(affected, (Entity)this.player, this.player, false, new ArrayList<Entity>(), this.player.getPosition(0.0f), MTConfig.FALLEN_DOWN_BLOCK_BREAK_PER_TICK, (bs, e, d, p) -> {
            if (FallenDownEntity.okToBreak(bs, this.player.level(), p)) {
                if (!fall) {
                    if (drop) {
                        Block.dropResources((BlockState)bs, (LevelAccessor)world, (BlockPos)p, (BlockEntity)world.getBlockEntity(p));
                    }
                    this.player.level().removeBlock(p, false);
                    this.player.level().setBlockAndUpdate(p, Blocks.AIR.defaultBlockState());
                    return true;
                }
                if (world.isEmptyBlock(p.below()) || FallingBlock.isFree((BlockState)world.getBlockState(p.below())) && p.getY() >= 0) {
                    FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)world, (BlockPos)Utils.toBlockPos((double)p.getX() + 0.5, (double)p.getY(), (double)p.getZ() + 0.5), (BlockState)world.getBlockState(p));
                    world.addFreshEntity((Entity)fallingblockentity);
                    return true;
                }
            }
            return false;
        });
    }

    public static boolean okToBreak(BlockState bs, Level w, BlockPos p) {
        return !EffectUtil.unchangableBlock(bs.getBlock()) && !bs.isAir() && w.getBlockEntity(p) == null;
    }

    public int getLife() {
        return (Integer)this.entityData.get(LIFE);
    }

    public void setLife(int l) {
        this.entityData.set(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.entityData.get(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.entityData.set(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.entityData.get(FIRED);
    }

    public void setFired(boolean f) {
        this.entityData.set(FIRED, (Object)f);
    }
}

