/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.projection;

import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.player.AnvilRepairEvent;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.datacomponents.projected.ProjectedMahou;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.PlayerHelp;
import stepsword.mahoutsukai.util.Utils;

public class ProjectionSpellEffect {
    public static boolean projection(Player caster, ItemStack toProject) {
        int setDamage = MTConfig.PROJECTION_DURABILITY_FACTOR;
        if (toProject != null) {
            if (ProjectionSpellEffect.canProject(toProject, caster.level())) {
                ItemStack stack = toProject.copy();
                stack.setCount(1);
                if (stack.isDamageableItem()) {
                    if (MTConfig.PROJECTION_DURABILITY_FLAT) {
                        setDamage = stack.getMaxDamage() - setDamage;
                    }
                    stack.setDamageValue(setDamage);
                    stack = ProjectionSpellEffect.removeDisallowedEnchants(stack);
                    StrengtheningSpellEffect.reduceStrengthened(stack, StrengtheningSpellEffect.getStrengthened(stack));
                    ProjectionSpellEffect.setProjected(stack);
                    return caster.addItem(stack);
                }
            } else {
                ProjectionSpellEffect.projectionHelp(caster, toProject);
            }
        }
        return false;
    }

    public static void setProjected(ItemStack s) {
        ProjectedMahou mahou = Utils.getProjectedMahou(s);
        mahou.setProjected(true);
        Utils.setProjectedMahou(s, mahou);
    }

    public static boolean getProjected(ItemStack s) {
        if (Utils.hasProjectedMahou(s)) {
            ProjectedMahou mahou = Utils.getProjectedMahou(s);
            return mahou.getProjected();
        }
        return false;
    }

    public static void projectionUpdateAnvil(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if ((ProjectionSpellEffect.getProjected(left) || ProjectionSpellEffect.getProjected(right)) && MTConfig.PROJECTION_ANVIL_CANCEL) {
            event.setCanceled(true);
        }
    }

    public static void projectionRepairAnvil(AnvilRepairEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if ((ProjectionSpellEffect.getProjected(left) || ProjectionSpellEffect.getProjected(right)) && !MTConfig.PROJECTION_ANVIL_CANCEL) {
            ItemEnchantments enchs = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)event.getOutput());
            ItemEnchantments enchsleft = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)left);
            ItemEnchantments enchsright = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)right);
            for (Holder e : enchs.keySet()) {
                if (!enchsleft.entrySet().contains(e) || !enchsright.entrySet().contains(e)) continue;
                int m = enchsleft.getLevel(e);
                int k = enchsright.getLevel(e);
                EffectUtil.addEnchantment(right, (Holder<Enchantment>)e, Math.min(m, k));
            }
        }
    }

    public static void projectionHelp(Player caster, ItemStack stack) {
        if (!stack.isEmpty() && !stack.isDamageableItem()) {
            PlayerHelp.sendHelpMessage(caster, PlayerHelp.Message.PROJECTION_NO_UNBREAKABLE);
        } else {
            PlayerHelp.sendHelpMessage(caster, PlayerHelp.Message.PROJECTION_NOT_ALLOWED);
        }
    }

    public static ItemStack memorize(Player caster) {
        if (caster != null) {
            Entity e = Utils.selectEntityNearCursor(caster, MTConfig.GLOBAL_LOOK_RANGE, caster.level(), a -> Utils.getPredicate(Utils.MAHOU_SELECTION.SCROLL_PROJECTION, a, caster), Utils.nearAllowed(Utils.MAHOU_SELECTION.SCROLL_PROJECTION));
            if (e instanceof LivingEntity) {
                Iterable lst = ((LivingEntity)e).getHandSlots();
                for (ItemStack tmp : lst) {
                    if (ProjectionSpellEffect.canProject(tmp, caster.level())) {
                        return tmp;
                    }
                    ProjectionSpellEffect.projectionHelp(caster, tmp);
                }
            } else if (e instanceof ItemEntity) {
                ItemEntity ie = (ItemEntity)e;
                if (ProjectionSpellEffect.canProject(ie.getItem(), caster.level())) {
                    return ie.getItem();
                }
                ProjectionSpellEffect.projectionHelp(caster, ie.getItem());
            } else if (e instanceof ItemFrame) {
                ItemFrame frame = (ItemFrame)e;
                if (ProjectionSpellEffect.canProject(frame.getItem(), caster.level())) {
                    return frame.getItem();
                }
                ProjectionSpellEffect.projectionHelp(caster, frame.getItem());
            } else if (e instanceof WeaponProjectileEntity) {
                WeaponProjectileEntity wpe = (WeaponProjectileEntity)e;
                if (ProjectionSpellEffect.canProject(wpe.getStack(), caster.level())) {
                    return wpe.getStack();
                }
                ProjectionSpellEffect.projectionHelp(caster, wpe.getStack());
            } else if (e instanceof ThrownTrident && e.getWeaponItem() != null) {
                if (ProjectionSpellEffect.canProject(e.getWeaponItem(), caster.level())) {
                    return e.getWeaponItem();
                }
                ProjectionSpellEffect.projectionHelp(caster, e.getWeaponItem());
            }
        }
        return null;
    }

    public static boolean canProject(ItemStack stack, Level level) {
        Item tmpi = stack.getItem();
        boolean ret = tmpi instanceof BowItem || tmpi instanceof SwordItem || tmpi instanceof AxeItem || tmpi instanceof HoeItem || tmpi instanceof ShovelItem || tmpi instanceof PickaxeItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof TridentItem || tmpi instanceof CrossbowItem;
        return ret && !ProjectionSpellEffect.disallowed(tmpi, level) && stack.isDamageableItem() || EffectUtil.inItemBlacklist(tmpi, MTConfig.PROJECTION_EXPLICIT_WHITELIST, level);
    }

    public static boolean disallowed(Item tmpi, Level level) {
        if (Utils.getRegistryKey(tmpi, level) != null) {
            HashSet<? extends String> disallowed = new HashSet<String>(MTConfig.PROJECTION_BLACKLIST);
            if (MTConfig.PROJECTION_IS_BLACKLIST) {
                return disallowed.contains(Utils.getRegistryName(tmpi, level)) || disallowed.contains(Utils.getRegistryKey(tmpi, level).getNamespace());
            }
            return !disallowed.contains(Utils.getRegistryName(tmpi, level)) && !disallowed.contains(Utils.getRegistryKey(tmpi, level).getNamespace());
        }
        return false;
    }

    public static ItemStack removeDisallowedEnchants(ItemStack stack) {
        ItemStack copy = stack.copy();
        HashSet<? extends String> disallowed = new HashSet<String>(MTConfig.PROJECTION_ENCHANTMENT_BLACKLIST);
        ItemEnchantments itemenchantments = EnchantmentHelper.updateEnchantments((ItemStack)stack, e -> e.removeIf(ee -> disallowed.contains(ee.getRegisteredName())));
        EnchantmentHelper.setEnchantments((ItemStack)copy, (ItemEnchantments)itemenchantments);
        return copy;
    }
}

