/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.covers1624.quack.util.CrashLock;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ExceptionMessageEventHandler {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");
    public static Set<String> exceptionMessageCache = new HashSet<String>();
    private static long lastExceptionClear;

    public static void init() {
        LOCK.lock();
        NeoForge.EVENT_BUS.addListener(ExceptionMessageEventHandler::clientTick);
    }

    private static void clientTick(ClientTickEvent.Post event) {
        long time = System.nanoTime();
        if (TimeUnit.NANOSECONDS.toSeconds(time - lastExceptionClear) > 5L) {
            lastExceptionClear = time;
            exceptionMessageCache.clear();
        }
    }
}

