/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.block;

import codechicken.lib.block.LazyStateBlock;
import codechicken.lib.block.component.PropertyComponent;
import codechicken.lib.block.component.StateAwareComponent;
import codechicken.lib.block.component.data.DataGenComponent;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class ModularBlock
extends LazyStateBlock {
    protected final List<Component> componentList = new LinkedList<Component>();
    protected final List<DataGenComponent> datagenComponents = new LinkedList<DataGenComponent>();
    protected final List<StateAwareComponent> stateComponents = new LinkedList<StateAwareComponent>();

    public ModularBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public final <T extends Component> T addComponent(T comp) {
        comp.block = this;
        if (comp instanceof PropertyComponent) {
            PropertyComponent propComp = (PropertyComponent)comp;
            this.addProperty(propComp.property, (Comparable)SneakyUtils.unsafeCast(propComp.defaultValue));
        }
        if (comp instanceof StateAwareComponent) {
            StateAwareComponent stateComp = (StateAwareComponent)comp;
            this.stateComponents.add(stateComp);
        }
        if (comp instanceof DataGenComponent) {
            DataGenComponent dataComp = (DataGenComponent)comp;
            if (DatagenModLoader.isRunningDataGen()) {
                this.datagenComponents.add(dataComp);
            }
            return comp;
        }
        this.componentList.add(comp);
        return comp;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        StateAwareComponent component;
        BlockState state = this.defaultBlockState();
        Iterator<StateAwareComponent> iterator = this.stateComponents.iterator();
        while (iterator.hasNext() && (state = (component = iterator.next()).getStateForPlacement(state, ctx)) != null) {
        }
        return state;
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation) {
        for (StateAwareComponent component : this.stateComponents) {
            state = component.rotate(state, level, pos, rotation);
        }
        return state;
    }

    public List<DataGenComponent> getDatagenComponents() {
        return Collections.unmodifiableList(this.datagenComponents);
    }

    public static abstract class Component {
        @Nullable
        ModularBlock block;

        public ModularBlock getBlock() {
            return Objects.requireNonNull(this.block, "Not yet added to a block.");
        }
    }
}

