/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.entity;

import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.registries.AdditionsBlocks;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityObsidianTNT
extends PrimedTnt {
    public EntityObsidianTNT(EntityType<EntityObsidianTNT> type, Level world) {
        super(type, world);
        this.setFuse(MekanismAdditionsConfig.additions.obsidianTNTDelay.get());
        this.setBlockState(AdditionsBlocks.OBSIDIAN_TNT.defaultState());
    }

    @Nullable
    public static EntityObsidianTNT create(Level world, double x, double y, double z, @Nullable LivingEntity igniter) {
        EntityObsidianTNT tnt = (EntityObsidianTNT)((EntityType)AdditionsEntityTypes.OBSIDIAN_TNT.get()).create(world);
        if (tnt == null) {
            return null;
        }
        tnt.setPos(x, y, z);
        double d0 = world.random.nextDouble() * 6.2831854820251465;
        tnt.setDeltaMovement(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        tnt.xo = x;
        tnt.yo = y;
        tnt.zo = z;
        tnt.owner = igniter;
        return tnt;
    }

    public boolean isPushable() {
        return true;
    }

    public void tick() {
        super.tick();
        if (this.isAlive() && this.getFuse() > 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void explode() {
        this.level().explode((Entity)this, Explosion.getDefaultDamageSource((Level)this.level(), (Entity)this), (ExplosionDamageCalculator)(this.usedPortal ? USED_PORTAL_DAMAGE_CALCULATOR : null), this.getX(), this.getY(0.0625), this.getZ(), MekanismAdditionsConfig.additions.obsidianTNTBlastRadius.get(), false, Level.ExplosionInteraction.TNT);
    }

    @NotNull
    public EntityType<?> getType() {
        return (EntityType)AdditionsEntityTypes.OBSIDIAN_TNT.value();
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack(AdditionsBlocks.OBSIDIAN_TNT);
    }
}

