/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.block.plastic;

import mekanism.additions.common.block.plastic.BlockPlastic;
import mekanism.additions.common.block.plastic.BlockPlasticTransparentSlab;
import mekanism.additions.common.block.plastic.BlockPlasticTransparentStairs;
import mekanism.api.text.EnumColor;
import mekanism.common.block.attribute.Attributes;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.block.states.BlockStateHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockPlasticTransparent
extends BlockPlastic {
    public BlockPlasticTransparent(EnumColor color) {
        super(color, properties -> properties.strength(5.0f, 6.0f).noOcclusion().isValidSpawn(Attributes.AttributeMobSpawn.NEVER_PREDICATE).isSuffocating(BlockStateHelper.NEVER_PREDICATE).isViewBlocking(BlockStateHelper.NEVER_PREDICATE));
    }

    protected float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return 0.8f;
    }

    protected boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    protected boolean skipRendering(@NotNull BlockState state, @NotNull BlockState adjacentBlockState, @NotNull Direction side) {
        return BlockPlasticTransparent.isSideInvisible(this, state, adjacentBlockState, side);
    }

    public Integer getBeaconColorMultiplier(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockPos beaconPos) {
        return this.getColor().getPackedColor();
    }

    public static boolean isSideInvisible(@NotNull IColoredBlock block, @NotNull BlockState state, @NotNull BlockState adjacentBlockState, @NotNull Direction side) {
        IColoredBlock plastic;
        Block adjacentBlock = adjacentBlockState.getBlock();
        if ((adjacentBlock instanceof BlockPlasticTransparent || adjacentBlock instanceof BlockPlasticTransparentSlab || adjacentBlock instanceof BlockPlasticTransparentStairs) && (plastic = (IColoredBlock)adjacentBlock).getColor() == block.getColor()) {
            try {
                VoxelShape shape = state.getShape(null, null);
                VoxelShape adjacentShape = adjacentBlockState.getShape(null, null);
                VoxelShape faceShape = shape.getFaceShape(side);
                VoxelShape adjacentFaceShape = adjacentShape.getFaceShape(side.getOpposite());
                return !Shapes.joinIsNotEmpty((VoxelShape)faceShape, (VoxelShape)adjacentFaceShape, (BooleanOp)BooleanOp.ONLY_FIRST);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

