/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import mekanism.additions.client.model.ModelBabyEnderman;
import mekanism.additions.client.render.entity.layer.BabyEndermanEyesLayer;
import mekanism.additions.client.render.entity.layer.BabyEndermanHeldBlockLayer;
import mekanism.additions.common.entity.baby.EntityBabyEnderman;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RenderBabyEnderman
extends MobRenderer<EntityBabyEnderman, ModelBabyEnderman> {
    private static final ResourceLocation ENDERMAN_TEXTURES = ResourceLocation.withDefaultNamespace((String)"textures/entity/enderman/enderman.png");
    private final RandomSource random = RandomSource.create();

    public RenderBabyEnderman(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelBabyEnderman(context.bakeLayer(ModelLayers.ENDERMAN)), 0.5f);
        this.addLayer((RenderLayer)new BabyEndermanEyesLayer((RenderLayerParent<EntityBabyEnderman, ModelBabyEnderman>)this));
        this.addLayer(new BabyEndermanHeldBlockLayer((RenderLayerParent<EntityBabyEnderman, ModelBabyEnderman>)this));
    }

    public void render(EntityBabyEnderman enderman, float entityYaw, float partialTicks, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int packedLightIn) {
        ModelBabyEnderman model = (ModelBabyEnderman)this.getModel();
        model.carrying = enderman.getCarriedBlock() != null;
        model.creepy = enderman.isCreepy();
        super.render((LivingEntity)enderman, entityYaw, partialTicks, matrix, renderer, packedLightIn);
    }

    @NotNull
    public Vec3 getRenderOffset(EntityBabyEnderman enderman, float partialTicks) {
        if (enderman.isCreepy()) {
            double offset = 0.02 * (double)enderman.getScale();
            return new Vec3(this.random.nextGaussian() * offset, 0.0, this.random.nextGaussian() * offset);
        }
        return super.getRenderOffset((Entity)enderman, partialTicks);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull EntityBabyEnderman enderman) {
        return ENDERMAN_TEXTURES;
    }
}

