/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.toast;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class SimpleToast
implements Toast {
    private static final ResourceLocation BG_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"polylib", (String)"textures/toast.png");
    private final Component title;
    private final Component description;
    private ItemStack displayIconStack = ItemStack.EMPTY;
    private ResourceLocation iconResourceLocation;

    public SimpleToast(Component title, Component description) {
        this.title = title;
        this.description = description;
    }

    public SimpleToast(Component title, Component description, ItemStack itemStack) {
        this.title = title;
        this.description = description;
        this.displayIconStack = itemStack;
    }

    public SimpleToast(Component title, Component description, ResourceLocation resourceLocation) {
        this.title = title;
        this.description = description;
        this.iconResourceLocation = resourceLocation;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long l) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BG_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(BG_TEXTURE, 0, 0, 0.0f, 0.0f, this.width(), this.height(), this.width(), this.height());
        if (this.iconResourceLocation != null) {
            this.renderImage(guiGraphics, toastComponent, this.iconResourceLocation);
        }
        if (this.title != null) {
            List list = toastComponent.getMinecraft().font.split((FormattedText)this.description, 125);
            int n = 0xFF88FF;
            if (list.size() == 1) {
                guiGraphics.drawString(Minecraft.getInstance().font, this.title, 30, 7, n | 0xFF000000);
                guiGraphics.drawString(Minecraft.getInstance().font, (FormattedCharSequence)list.get(0), 30, 18, -1);
            } else if (l < 1500L) {
                int k = Mth.floor((float)(Mth.clamp((float)((float)(1500L - l) / 300.0f), (float)0.0f, (float)1.0f) * 255.0f)) << 24 | 0x4000000;
                guiGraphics.drawString(Minecraft.getInstance().font, this.title, 30, 11, n | k);
            } else {
                int k = Mth.floor((float)(Mth.clamp((float)((float)(l - 1500L) / 300.0f), (float)0.0f, (float)1.0f) * 252.0f)) << 24 | 0x4000000;
                int n2 = this.height() / 2;
                int n3 = list.size();
                Objects.requireNonNull(toastComponent.getMinecraft().font);
                int m = n2 - n3 * 9 / 2;
                for (FormattedCharSequence formattedCharSequence : list) {
                    guiGraphics.drawString(Minecraft.getInstance().font, formattedCharSequence, 30, m, 0xFFFFFF | k);
                    Objects.requireNonNull(toastComponent.getMinecraft().font);
                    m += 9;
                }
            }
            if (!this.displayIconStack.isEmpty()) {
                guiGraphics.renderItem(this.displayIconStack, 8, 8);
            }
            return l >= 5000L ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }

    public void renderImage(GuiGraphics guiGraphics, ToastComponent toastComponent, ResourceLocation resourceLocation) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resourceLocation);
        RenderSystem.enableBlend();
        guiGraphics.blit(resourceLocation, 8, 8, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.enableBlend();
    }
}

