/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.List;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IMekanismHeatHandler;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.resolver.manager.HeatHandlerManager;
import mekanism.common.content.network.transmitter.ThermodynamicConductor;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityThermodynamicConductor
extends TileEntityTransmitter {
    private final HeatHandlerManager heatHandlerManager = new HeatHandlerManager(direction -> {
        ThermodynamicConductor conductor = this.getTransmitter();
        if (direction != null && conductor.getConnectionTypeRaw(direction) == ConnectionType.NONE || conductor.isRedstoneActivated()) {
            return Collections.emptyList();
        }
        return conductor.getHeatCapacitors(direction);
    }, new IMekanismHeatHandler(){

        @Override
        @NotNull
        public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction side) {
            return TileEntityThermodynamicConductor.this.heatHandlerManager.getContainers(side);
        }

        @Override
        public void onContentsChanged() {
        }
    });

    public TileEntityThermodynamicConductor(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver(this.heatHandlerManager);
    }

    protected ThermodynamicConductor createTransmitter(Holder<Block> blockProvider) {
        return new ThermodynamicConductor(blockProvider, this);
    }

    public ThermodynamicConductor getTransmitter() {
        return (ThermodynamicConductor)super.getTransmitter();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.THERMODYNAMIC_CONDUCTOR;
    }

    @Override
    @NotNull
    protected BlockState upgradeResult(@NotNull BlockState current, @NotNull BaseTier tier) {
        return BlockStateHelper.copyStateData(current, switch (tier) {
            case BaseTier.BASIC -> MekanismBlocks.BASIC_THERMODYNAMIC_CONDUCTOR;
            case BaseTier.ADVANCED -> MekanismBlocks.ADVANCED_THERMODYNAMIC_CONDUCTOR;
            case BaseTier.ELITE -> MekanismBlocks.ELITE_THERMODYNAMIC_CONDUCTOR;
            case BaseTier.ULTIMATE -> MekanismBlocks.ULTIMATE_THERMODYNAMIC_CONDUCTOR;
            default -> null;
        });
    }

    @Override
    public void sideChanged(@NotNull Direction side, @NotNull ConnectionType old, @NotNull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapability(Capabilities.HEAT, side);
        } else if (old == ConnectionType.NONE) {
            this.invalidateCapabilities();
        }
    }

    @Override
    public void redstoneChanged(boolean powered) {
        super.redstoneChanged(powered);
        if (powered) {
            this.invalidateCapabilityAll(Capabilities.HEAT);
        } else {
            this.invalidateCapabilities();
        }
    }
}

