/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.qio;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import mekanism.api.Action;
import mekanism.common.Mekanism;
import mekanism.common.attachments.qio.DriveContents;
import mekanism.common.attachments.qio.DriveMetadata;
import mekanism.common.content.qio.IQIODriveHolder;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.registries.MekanismDataComponents;
import net.minecraft.world.item.ItemStack;

public class QIODriveData {
    private final QIODriveKey key;
    private final long countCapacity;
    private final int typeCapacity;
    private final Object2LongMap<HashedItem> itemMap = new Object2LongOpenHashMap();
    private long itemCount;

    public QIODriveData(QIODriveKey key) {
        this.key = key;
        ItemStack driveStack = key.getDriveStack();
        IQIODriveItem driveItem = (IQIODriveItem)driveStack.getItem();
        this.countCapacity = driveItem.getCountCapacity(driveStack);
        this.typeCapacity = driveItem.getTypeCapacity(driveStack);
        ((DriveContents)driveStack.getOrDefault(MekanismDataComponents.DRIVE_CONTENTS, (Object)DriveContents.EMPTY)).loadItemMap(this);
        this.itemCount = this.itemMap.values().longStream().sum();
        key.updateMetadata(this);
    }

    public long add(HashedItem type, long amount, Action action) {
        long stored = this.getStored(type);
        if (this.itemCount == this.countCapacity || stored == 0L && this.itemMap.size() == this.typeCapacity) {
            return amount;
        }
        long toAdd = Math.min(amount, this.countCapacity - this.itemCount);
        if (action.execute()) {
            this.itemMap.put((Object)type, stored + toAdd);
            this.itemCount += toAdd;
            this.key.updateMetadata(this);
            this.key.dataUpdate();
        }
        return amount - toAdd;
    }

    public long remove(HashedItem type, long amount, Action action) {
        long stored = this.getStored(type);
        long removed = Math.min(amount, stored);
        if (action.execute()) {
            long remaining = stored - removed;
            if (remaining > 0L) {
                this.itemMap.put((Object)type, remaining);
            } else {
                this.itemMap.removeLong((Object)type);
            }
            this.itemCount -= removed;
            this.key.updateMetadata(this);
            this.key.dataUpdate();
        }
        return removed;
    }

    public long getStored(HashedItem type) {
        return this.itemMap.getOrDefault((Object)type, 0L);
    }

    public Object2LongMap<HashedItem> getItemMap() {
        return this.itemMap;
    }

    public QIODriveKey getKey() {
        return this.key;
    }

    public long getCountCapacity() {
        return this.countCapacity;
    }

    public int getTypeCapacity() {
        return this.typeCapacity;
    }

    public long getTotalCount() {
        return this.itemCount;
    }

    public int getTotalTypes() {
        return this.itemMap.size();
    }

    public record QIODriveKey(IQIODriveHolder holder, int driveSlot) {
        public void save(QIODriveData data) {
            this.holder.save(this.driveSlot, data);
        }

        public void dataUpdate() {
            this.holder.onDataUpdate();
        }

        public void updateMetadata(QIODriveData data) {
            ItemStack stack = this.getDriveStack();
            if (stack.getItem() instanceof IQIODriveItem) {
                stack.set(MekanismDataComponents.DRIVE_METADATA, (Object)new DriveMetadata(data));
            } else {
                Mekanism.logger.error("Tried to update QIO meta values on an invalid ItemStack ({}). Something has gone very wrong!", (Object)stack.getItem());
            }
        }

        public ItemStack getDriveStack() {
            return this.holder.getDriveSlots().get(this.driveSlot).getStack();
        }
    }
}

