/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class MinerFilter<FILTER extends MinerFilter<FILTER>>
extends BaseFilter<FILTER> {
    @SyntheticComputerMethod(getter="getReplaceTarget", setter="setReplaceTarget", threadSafeGetter=true, threadSafeSetter=true)
    public Item replaceTarget = Items.AIR;
    @SyntheticComputerMethod(getter="getRequiresReplacement", setter="setRequiresReplacement", threadSafeSetter=true, threadSafeGetter=true)
    public boolean requiresReplacement;

    protected static <FILTER extends MinerFilter<FILTER>> Products.P3<RecordCodecBuilder.Mu<FILTER>, Boolean, Item, Boolean> baseMinerCodec(RecordCodecBuilder.Instance<FILTER> instance) {
        return MinerFilter.baseCodec(instance).and((App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("replace_target", (Object)Items.AIR).forGetter(filter -> filter.replaceTarget)).and((App)Codec.BOOL.optionalFieldOf("requires_replacement", (Object)false).forGetter(filter -> filter.requiresReplacement));
    }

    protected static <FILTER extends MinerFilter<FILTER>> StreamCodec<RegistryFriendlyByteBuf, FILTER> baseMinerStreamCodec(Supplier<FILTER> constructor) {
        return StreamCodec.composite(MinerFilter.baseStreamCodec(constructor), Function.identity(), (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), filter -> filter.replaceTarget, (StreamCodec)ByteBufCodecs.BOOL, filter -> filter.requiresReplacement, (filter, replaceTarget, requiresReplacement) -> {
            filter.replaceTarget = replaceTarget;
            filter.requiresReplacement = requiresReplacement;
            return filter;
        });
    }

    protected MinerFilter() {
    }

    protected MinerFilter(boolean enabled, Item replaceTarget, boolean requiresReplacement) {
        super(enabled);
        this.replaceTarget = replaceTarget;
        this.requiresReplacement = requiresReplacement;
    }

    protected MinerFilter(FILTER filter) {
        super(filter);
        this.replaceTarget = ((MinerFilter)filter).replaceTarget;
        this.requiresReplacement = ((MinerFilter)filter).requiresReplacement;
    }

    public boolean replaceTargetMatches(@NotNull Item target) {
        return this.replaceTarget != Items.AIR && this.replaceTarget == target;
    }

    public abstract boolean canFilter(BlockState var1);

    @ComputerMethod
    public abstract boolean hasBlacklistedElement();

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.replaceTarget.hashCode();
        result = 31 * result + Boolean.hashCode(this.requiresReplacement);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        MinerFilter other = (MinerFilter)o;
        return this.requiresReplacement == other.requiresReplacement && this.replaceTarget == other.replaceTarget;
    }

    @Override
    @ComputerMethod(threadSafe=true)
    public abstract FILTER clone();
}

